@javascript @core @orgchart
Feature: Verify an org chart can be created.

  Background:
	Given I am on a Claromentis site
	And the following people exist:
	  | username  | password | surname   | firstname | email                 | manager   |
	  | director1 | password | Director1 | Dave1     | director1@example.com |		     |
	  | manager1  | password | Manager1  | Maggie1   | manager1@example.com  | director1 |
	  | manager2  | password | Manager2  | Maggie2   | manager2@example.com  | director1 |
	  | member1   | password | Member1   | Mark1     | member1@example.com   | manager1  |
	  | member2   | password | Member2   | Mark2     | member2@example.com   | manager1  |
	  | member3   | password | Member3   | Mark3     | member3@example.com   | manager2  |
	  | member4   | password | Member4   | Mark4     | member4@example.com   | manager2  |
	  | member5   | password | Member5   | Mark5     | member5@example.com   | manager2  |

	When I login as an admin user
	And I am on "/orgchart/admin"
	Then I should see "These are the currently available org charts"

	When I follow "Permissions"
	Then I should see "Specify who has rights to create and edit org charts."

	When I set permissions for "User: Claromentis Administrator"
	And I press "Apply permissions"
	Then I should see "Permissions updated"

  Scenario: Verify a simple org chart is generated and all users are present on it.

	Given I open the modules menu
	When I follow "Org Chart"
	Then I should see "You don't have any org charts to display."

	When I follow "Create org chart"
	And I fill in "Title" with "My Org Chart"
	And I follow "Browse"
	And I switch windows
	And I follow "Dave1 Director1"
	And I switch windows
	And I press "Save Org chart"
	Then I should see "Org chart created"
	And I should see "Dave1 Director1"
	And I should see "Maggie1 Manager1"
	And I should see "Maggie2 Manager2"
	And I should see "Mark1 Member1"
	And I should see "Mark2 Member2"
	And I should see "Mark3 Member3"
	And I should see "Mark4 Member4"
	And I should see "Mark5 Member5"

  Scenario: Verify a org chart is generated and all users are present except those which are excluded.

	Given I open the modules menu
	When I follow "Org Chart"
	Then I should see "You don't have any org charts to display."

	When I follow "Create org chart"
	And I fill in "Title" with "My Org Chart"
	And I click element with "Browse" to open a window and click the following:
	  | Dave1 Director1 |
	And I click element with "//div[@id='exclude_from_orgchart']//a[text()='Browse']" to open a window and click the following:
	  | Maggie2 Manager2 |
	And I press "Save Org chart"
	Then I should see "Org chart created"
	And I should see "Dave1 Director1"
	And I should see "Maggie1 Manager1"
	And I should see "Mark1 Member1"
	And I should see "Mark2 Member2"
	But I should not see "Maggie2 Manager2"
	And I should not see "Mark3 Member3"
	And I should not see "Mark4 Member4"
	And I should not see "Mark5 Member5"
