function explode(separator, string)
{
	var j, tmp;

	if (separator==null)
		return;

	var result = [];

	if (string === '' || string == null)
		return result;

	if (strpos(string, separator)<0) {
		result[0]=string;
		return result;
	}

	//-- errors handled
	tmp = string;
	j=0;

	while (strpos(tmp, separator)>-1) {
		result[j] = tmp.substring(0, strpos(tmp, separator));
		tmp = strDelete(tmp, 0, strpos(tmp, separator) + separator.length);
		j++;
	}

	if (tmp!=='')
		result[j] = tmp;

	return result;
}

function implode (glue, pieces)
{
	var i;
	var result = '';
	for (i=0;i<pieces.length;i++)
	{
		if (i == pieces.length-1)
		{
			result = result + pieces[i];
			break;
		}
		result = result + pieces[i] + glue;
	}
	return result;
}

function strpos(haystack, needle)
{
	var i;
	for (i=0;i<=(haystack.length - needle.length);i++)
	{
		if (haystack.substr(i, needle.length) == needle)
			return i;

	}
	return -1;
}
function strDelete(string, start, count)
{
	if (string=='' || count==0)
		return string;

	return string.substring(0, start-1) + string.substring(start+count, string.length);
}

var hp_day = new Array( '', 			// [0]  holiday name
						'N', 			// [1]  holiday char
						1, 				// [2]  can be declined
						1, 				// [3]  can be half day
						2, 				// [4]  index of limit action [increment | decrement | none]
						1, 				// [5]  index of notifying to [manager | whole group]
						'#000000', 		// [6]  font color
						'#0000ff',		// [7]  background color
						0,				// [8]  true - edit existing item
						0,				// [9]  id of existing item if [8] is true
                        0,				// [10] can overwrite global holiday (ie. can be set on non-working day)
						1,				// [11] user comment is mandatory
                        0				// [12] is system day
);

function ch_content(name, value)
{
	val = new String(value);
	document.getElementById(name+'1').innerHTML = value;
	document.getElementById(name+'2').innerHTML = value;
	document.getElementById(name+'3').innerHTML = value;
	name == 'hol_char' ? hp_day[1] = val : hp_day[0] = val;
}

function col_change(name, value) {
	var bgColor 	= document.getElementById('bg_color'),
		fontColor 	= document.getElementById('font_color'),
		hpTd1 		= document.getElementById('hp_td1'),
		hpTd2 		= document.getElementById('hp_td2'),
		hpTd3 		= document.getElementById('hp_td3'),
		colour 		= cla.colours.getContrastYIQ(value);

	if(name == 'bg_color'){
		bgColor.value = value;
		bgColor.style.backgroundColor = value;
		bgColor.style.color = colour;
		hpTd1.style.borderColor = value;
		hpTd2.style.borderColor = value;
		hpTd3.style.borderColor = value;
		jQuery(bgColor).next('.kp-note').css({'color' : colour});

		hp_day[7] = value;
	}

	if(name == 'font_color'){
		fontColor.value = value;
		fontColor.style.backgroundColor = value;
		fontColor.style.color = colour;
		hpTd1.style.color = value;
		hpTd2.style.color = value;
		hpTd3.style.color = value;
		hp_day[6] = value;
		jQuery(fontColor).next('.kp-note').css({'color' : colour});
	}
}

function dec_change(stat)
{
	if(stat == 1){
		document.getElementById('hp_td2').style.display = '';
		document.getElementById('hp_td22').style.display = '';
		document.getElementById('hp_td3').style.display = '';
		document.getElementById('hp_td33').style.display = '';
		hp_day[2] = 1;
	}else{
		document.getElementById('hp_td2').style.display = 'none';
		document.getElementById('hp_td22').style.display = 'none';
		document.getElementById('hp_td3').style.display = 'none';
		document.getElementById('hp_td33').style.display = 'none';
		hp_day[2] = 0;
	}
}

function half_change(stat)
{
	if(stat == 1){
		hp_day[3] = 1;
	}else{
		hp_day[3] = 0;
	}
}
function over_global_change(stat)
{
	if(stat == 1){
		hp_day[10] = 1;
	}else{
		hp_day[10] = 0;
	}
}

function user_comment_mandatory_change(stat)
{
	if(stat == 1){
		hp_day[11] = 1;
	}else{
		hp_day[11] = 0;
	}
}

function quotaChange(ind)
{
	hp_day[4] = ind;
}

function notifyChange(ind)
{
	hp_day[5] = ind;
}

function hp_day_to_html(e)
{
	ch_content('hol_name', hp_day[0]);
	ch_content('hol_char', hp_day[1]);
	document.getElementById('inp_name').value = hp_day[0];
	document.getElementById('inp_char').value = hp_day[1];
	dec_change(hp_day[2]);
	document.getElementById('can_decline').checked = hp_day[2];
	half_change(hp_day[3]);
	document.getElementById('can_half_day').checked = hp_day[3];

	el = document.getElementById('limit_action');
	document.getElementById('limit_action').options[hp_day[4]].selected = true;
	//document.getElementById('notify_to').options[hp_day[5]].selected = true;

	col_change('font_color', hp_day[6]);
	col_change('bg_color', hp_day[7]);
	jQuery('#font_color').val(hp_day[6]).change();
	jQuery('#bg_color').val(hp_day[7]).change();

	can_override_global = hp_day[10] == '1' ? 1 : 0;
	over_global_change(can_override_global);
	document.getElementById('can_over_global').checked = can_override_global;
	document.getElementById('cannot_over_global').checked = !can_override_global;

	user_comment_mandatory = hp_day[11] == '1' ? 1 : 0;
	document.getElementById('user_comment_mandatory').checked = user_comment_mandatory;
	user_comment_mandatory_change(user_comment_mandatory);

	var is_system_day = hp_day[12] && hp_day[12] !== "0";

	var radios = document.getElementsByName('can_over_global');

	jQuery("input[name='delete_day_option'][value='hide']").attr('checked',true);

	if (is_system_day) { // Checks if is a system day and disables the following if so.
		jQuery('#inp_char').closest('.form-group').hide();//jQuery('#inp_char').parentsUntil('.form-group').hide();
		jQuery('#limit_action').closest('.form-group').hide();
		jQuery('#weekday_type').closest('.form-group').hide();
		jQuery('#user_comment').closest('.form-group').hide();
		jQuery('#can_half_day').closest('.form-group').hide();
		jQuery('#delete_day').hide();
		jQuery('#create_copy_btn').hide();
	} else {
		jQuery('#inp_char').closest('.form-group').show();
		jQuery('#limit_action').closest('.form-group').show();
		jQuery('#weekday_type').closest('.form-group').show();
		jQuery('#user_comment').closest('.form-group').show();
		jQuery('#can_half_day').closest('.form-group').show();
		jQuery('#delete_day').show();
	}

	var is_editing_existing = hp_day[8] && hp_day[8] !== "0";
    if (is_editing_existing) {
        jQuery("#edit_day").show();
        if (is_system_day) {
            jQuery('#delete_day').hide();
        } else {
            jQuery('#delete_day').show();
        }
        jQuery('#create_copy_btn').show();
        jQuery("#create_btn").hide();
    } else {
        jQuery("#edit_day").hide();
        jQuery("#create_btn").show();
        jQuery('#create_copy_btn').hide();
    }

    try
    {	// Makes sure the right label is shown in case js has changed it.
    	jQuery('#delete_day').val(lmsg('common.tree_view.delete'));
    	jQuery('#hp_day_is_hidden').val(false);

        var caller = e ? e.target : window.event.srcElement;
        if (caller.attributes.class && caller.attributes.class.value.indexOf('hidden-day') != -1 && caller.attributes.href.value == '#editDayType')
        {   // Hidden days.
            jQuery('#create_copy_btn').hide(); // Hides the create copy button.
            jQuery('#hp_day_is_hidden').val(true);
            jQuery('#delete_day').val(lmsg('holidays.admin.delete_restore_day'));
        }
	}
	catch (e)
	{
	    return false;
	}
}

function addHpDay(){
	var err;
	if (err = checkHpDay()) { alert(err); return false; }
	document.getElementById('hp_day_action').value = 'add';
	document.getElementById('hp_day_string').value = implode('_', hp_day);
	document.getElementById('hp_config_form').submit();
	return false;
}

function editHpDay(){
	var err;
	if (err = checkHpDay()) { alert(err); return false; }
	document.getElementById('hp_day_action').value = 'edit';
	document.getElementById('hp_day_string').value = implode('_', hp_day);
	document.getElementById('hp_config_form').submit();
	return false;
}

function checkHpDay(){
    var reg =/_/;
    if (reg.test(hp_day[0]) || reg.test(hp_day[1])) return document.lc['holidays.admin.not_underscore'];
    if (hp_day[0] == "") return document.lc['holidays.admin.day_empty'];
    return "";
}

function delHpDay(){
	var is_system_day = hp_day[12] && hp_day[12] !== "0";
	if(is_system_day){
		alert(document.lc['holidays.admin.cant_del_days']);
	}
	else {
		var selected_day = jQuery("#existing_days_list option[value='" + hp_day[9] + "']");
		var is_hidden_day = jQuery('#hp_day_is_hidden').val();
		jQuery('#editDayType').modal('hide');
		jQuery("#existing_days_list option").show(); // Makes sure any hidden opt is reset.
        jQuery('#reassign_day_option').show();
		jQuery("#existing_days_list option[value='" + selected_day.siblings().first().val() + "']").attr('selected',true);
		selected_day.hide(); // Don't show itself in the list.
		jQuery("#delete_day_name").text(lmsg("holidays.admin.delete_day_name", hp_day[0]));
		if (is_hidden_day == "true") // shows either the hide or the restore option, base on the day's status.
		{	// Action when this is a hidden day.
			jQuery('#hide_day_option').hide();
			//jQuery('#reassign_day_option').hide();
			jQuery('#restore_day_option').show();
			jQuery('#radio_restore_day').attr("checked", "checked");
		}
		else
		{	// Action when this is NOT a hidden day.
			jQuery('#hide_day_option').show();
			//jQuery('#reassign_day_option').show();
			jQuery('#restore_day_option').hide();
			jQuery('#radio_hide_day').attr("checked", "checked");
		}
		jQuery('#del-confirmation').modal('show');
	}
	return false;
}

function continueHpDayDeletion(){
	var action = jQuery("input[name='delete_day_option']:checked").val();
	// Asks for confirmation before proceeding if the action will delete the day.
	if (action == 'hide' || action == 'restore' || confirm(lmsg('holidays.admin.delete_day_confirmation'))){
	    document.getElementById('hp_day_action').value = action;
	    document.getElementById('hp_day_string').value = implode('_', hp_day);
	    if (action == 'restore'){
			if (err = checkHpDay()) return alert(err);
    		document.getElementById('hp_day_action').value = 'restore';
    		document.getElementById('hp_day_string').value = implode('_', hp_day);
    		document.getElementById('hp_config_form').submit();
	    }
	    else if (action == 'reassign'){
	        var days_list = document.getElementById("existing_days_list");
	        var assign_to = days_list.options[days_list.selectedIndex];
	        document.getElementById('hp_day_reassign_to_id').value = assign_to.value;
	        document.getElementById('hp_day_reassign_to_name').value = assign_to.text;
	    }
	    document.getElementById('hp_config_form').submit();
	}
    jQuery('#del-confirmation').modal('hide');
}

hp_day_to_html();

// Forces the page to scroll to top.
jQuery(document).ready(function(){
    jQuery(".table.hidden-days-table").hide();
    jQuery(".cancel-day-deletion").click(function(){
        jQuery("#del-confirmation").modal('hide');
    });
});

function show_hidden_days() {
    jQuery(".table.hidden-days-table").toggle();
    if (jQuery(".table.hidden-days-table").is(":visible")) {
		jQuery('#show_hidden_days_link').text(lmsg('holidays.holidays_admin.hide_hidden_days'));
    }
    else {
    	jQuery('#show_hidden_days_link').text(lmsg('holidays.holidays_admin.show_hidden_days'));
    }
}