require(['jquery', 'domReady', 'jquery.tablednd'], function (jQuery, domReady) {
    domReady(function () {
        jQuery("#changed_notify").css({'position' : 'absolute', 'display' : 'none'});

        jQuery("#links_table").tableDnD({
            onDragClass: "dragged_tr",
            dragHandle : '.js-drag-handle',
            onDrop: function(table, row)
            {
                var rows = table.tBodies[0].rows,
                    values = [];
                for (var i=0; i<rows.length; i++) {
                    values[i] = rows[i].id.substr(4);
                }
                xajax_redefine_displayorders(values);
            }
        });
    });
});

function MarkItem(abyr, id) {
	document.forms["links_form"].elements["selected_ids_" + id].checked = true;
}
function FixLink(input) {
	var host = window.location.hostname + '/';

	if (input.value.length === 0) {
		return;
	}

	jQuery.each(["www."], function(k, v) {
		if (input.value.substr(0, v.length) == v) {
			input.value = "http://" + input.value;
		}
	});

	if (!input.value.match(/^https?:\/\/|\//)) {
		input.value = "http://" + input.value;
	}

	jQuery.each([host, "http://" + host, "https://" + host], function(k, v) {
		if (input.value.substr(0, v.length) == v) {
			input.value = "/" + input.value.substr(v.length);
		}
	});
}
function infobar_confirm_line(message, btn_msg, fnc1) {
	var line = jQuery('#confirm_line').stop().empty().addClass('alert alert-success');
	var msg = document.createElement('b');
	msg.innerHTML = message + ' &nbsp; ';
	line.append(msg);

	if (btn_msg) {
		var btn = document.createElement('input');
		btn.type = 'button';
		btn.className = "btn btn-secondary";
		btn.value = btn_msg;
		btn.onclick = function() {fnc1();jQuery('#confirm_line').hide();};
		line.append(btn);
	}
	line.fadeIn();
}
function setChecked(elem){
    var name = elem.attr('name');
    var pattern = /\w+\[(\d+)\]/;
    var match = pattern.exec(name);
    if(match == null){

    } else {
        var rowId = match[1];
        $('#selected_ids_'+rowId).prop('checked', true);
    }
}
$(document).ready(function(){
    $('.form-control').each(function(){
    	$(this).on('input', function(){
    		setChecked($(this));
    	});
    });
})
