<?php
$_db_migration_to = '24.02'; // 7.3 beta
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('101_remove_scanned_import.php', <<<'DB_UPDATE_FILE'
<?php

/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$db->DropTable('ERMS_ImportLocation');
$db->DropTable('ERMS_importmap');
$db->DropTable('ERMS_importmap_data');
DB_UPDATE_FILE
);


$migrations->Run('102_localization_move.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */

$dir = $migrations->GetLocalDataDir().'/i18n_cache';
if (!is_dir($dir))
	mkdir($dir, 0777);
chmod($dir, 0777);

global $APPDATA;
if (is_dir($APPDATA.'/sys'))
{
	$files = glob($APPDATA.'/sys/*');
	foreach ($files as $f)
		@unlink($f);
	@unlink($APPDATA.'/sys');
}


DB_UPDATE_FILE
);


$migrations->Run('103_cdn_add_files_table.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$db->CreateTable('cdn_files', array(
	'parent_path' => "VARCHAR_MAX NULL",
	'type' 		=> 'INT NOT_NULL DEFAULT 0',
	'name'		=> "VARCHAR_MAX NULL",
	'url' 		=> 'VARCHAR_MAX NULL',
	'file_size'	=> 'INT NULL',
	'modified' 	=> 'INT_DATE NULL'
), true);

DB_UPDATE_FILE
);


$migrations->Run('105_move_publish_template_dirs.php', <<<'DB_UPDATE_FILE'
<?php
/**
 * Move subfolders of /intranet/publish/templates to /appdata/publish/templates.
 * All of these subfolders pertain to Publish templates uploads for publish pages
 * with the same name as the folder.
 */
$base = realpath($GLOBALS['INTRANET'].'/../').'/';
$old_dir = $base.'intranet/publish/templates/';
$new_dir = $base.'appdata/publish/templates/';

// Create $new_dir path with 0777 permissions
if (!is_dir($new_dir))
{
	mkdir($new_dir, 0777, true);
	chmod($base.'appdata', 0777);
	chmod($base.'appdata/publish', 0777);
	chmod($new_dir, 0777);
}

/**
 * Include a couple of filesystem functions for copying directories
 * recursively. Code for outputting errors has been removed.
 */
if (!function_exists('mptd_create_path'))
{
	/**
	 * Create all required directories in specified path.
	 * Permissions default to 0777.
	 *
	 * @param string $path
	 * @param int|null $perms
	 *
	 * @return bool
	 * @see /intranet/common/filesystem.php
	 */
	function mptd_create_path($path, $perms = null)
	{
		$DS = DIRECTORY_SEPARATOR;
		if (is_null($perms))
			$perms = 0777;

		if (is_dir($path))
		{
			@chmod($path, $perms);
			return true;
		}

		$path_elements = preg_split('@/|\\\\@', $path);
		if ($path_elements[count($path_elements) - 1] == '')
			array_pop($path_elements);
		$path_elements_tmp = $path_elements;

		$success = false;
		while ((sizeof($path_elements_tmp) >= 1 && $path_elements_tmp[0] != '') || (sizeof($path_elements_tmp) > 1 && $path_elements_tmp[0] == ''))
		{
			$dirname = join($DS, $path_elements_tmp);
			if (is_dir($dirname) || @mkdir($dirname))
			{
				$success = true;
				if (!is_null($perms))
					@chmod($dirname, $perms);
				break;
			}
			array_pop($path_elements_tmp);
		}

		if (!$success)
			return false;

		$cnt = sizeof($path_elements_tmp)+1;
		for ($i = $cnt; $i <= sizeof($path_elements); ++$i)
		{
			$dirname = join($DS, array_slice($path_elements, 0, $i));
			if (!is_dir($dirname) && !@mkdir($dirname))
				$success = false;
			if (!is_null($perms))
				@chmod($dirname, $perms);
		}

		return $success;
	}
}

if (!function_exists('mptd_copydir_r'))
{
	/**
	 * Recursively copy all content of one directory to another.
	 * On error, returns false
	 *
	 * @param string $source_path
	 * @param string $target_path
	 *
	 * @return bool
	 * @see /intranet/common/filesystem.php
	 */
	function mptd_copydir_r($source_path, $target_path)
	{
		$dir = opendir($source_path);

		mptd_create_path($target_path);

		while (($file = readdir($dir)) !== false)
		{
			if ($file == '.' || $file == '..')
				continue;

			if (is_dir($source_path.'/'.$file))
			{
				mkdir($target_path);

				if (!is_dir($target_path.'/'.$file) && !mkdir($target_path.'/'.$file))
					return false;

				if (!mptd_copydir_r($source_path.'/'.$file, $target_path.'/'.$file))
					return false;
			} else
			{
				if (!copy($source_path.'/'.$file, $target_path.'/'.$file))
					return false;
			}
		}

		closedir($dir);

		return true;
	}
}

// Read files and directories in $old_dir
$files = glob($old_dir . '*');

// Move all files and directories from $old_dir into $new_dir
// Copy if unable to move, and delete if the file is .xml
foreach ($files as $file)
{
	if (file_exists($file))
	{
		$ext = pathinfo($file, PATHINFO_EXTENSION);

		$new_file = $new_dir . basename($file);

		// Try renaming, fall back to copying
		if(!@rename($file, $new_file)){
			if (is_dir($file))
				mptd_copydir_r($file, $new_file);
			else
				copy($file, $new_file);
		}
	}
}
DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('24.02');
