<?php
$_db_migration_to = '27.07';
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_hd_project_recreate.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->DropTable('hd_project_bak');
$db->RenameTable('hd_project', 'hd_project_bak');

// hd_project
$table_descr = array(
	'id'	=>	"IDENTITY",
	'name'	=>	"VARCHAR(160) NULL",
	'description'	=>	"VARCHAR(255) NULL",
	'status'	=>	"INT NULL",
	'list_form_fields'	=>	"CLOB NULL",
	'send_form_fields'	=>	"CLOB NULL",
	'issues_colors'	=>	"CLOB NULL",
	'default_filter'	=>	"CLOB NULL",
	'issues_on_page'	=>	"INT NULL",
	'app_id'	=>	"INT NOT_NULL DEFAULT 0",
	'issue_age'	=>	"INT NOT_NULL DEFAULT 0",
	'mail_account_id'	=>	"INT NULL DEFAULT 0",
	'from_field_save'	=>	"VARCHAR(80) NULL",
	'subject_field_save'	=>	"VARCHAR(80) NULL",
	'body_field_save'	=>	"VARCHAR(80) NULL",
	'process_mail_attachments'	=>	"BOOL DEFAULT 0",
	'view_rights'	=>	"INT NOT_NULL DEFAULT 0",
	'update_rights'	=>	"INT NOT_NULL DEFAULT 0",
	'report_rights'	=>	"INT NOT_NULL DEFAULT 0",
	'handle_rights'	=>	"INT NOT_NULL DEFAULT 0",
	'update_status_rights'	=>	"INT NOT_NULL DEFAULT 0",
	'assign_rights'	=>	"INT NOT_NULL DEFAULT 0",
	'notes_rights'	=>	"INT NOT_NULL DEFAULT 0",
	'files_rights'	=>	"INT NOT_NULL DEFAULT 0",
	'manage_rights'	=>	"INT NOT_NULL DEFAULT 0",
	'statistic_rights'	=>	"INT NOT_NULL DEFAULT 0",
	'view_notes_rights'	=>	"INT NOT_NULL DEFAULT 0",
	'view_files_rights'	=>	"INT NOT_NULL DEFAULT 0",
	'view_history_rights'	=>	"INT NOT_NULL DEFAULT 0",
	'private_notes_rights'	=>	"INT NULL DEFAULT 0",
	'def_sort_field'	=>	"VARCHAR(80) NULL",
	'def_sort_dir'	=>	"INT NOT_NULL DEFAULT 0",
	'reply_to_email'	=>	"BOOL NOT_NULL DEFAULT 0",
	'reply_subject'	=>	"VARCHAR(255) NULL",
	'reply_text'	=>	"CLOB NULL",
	'notif_subject_field'	=>	"VARCHAR(80) NULL",
	'is_status_field'	=>	"BOOL NOT_NULL DEFAULT 0",
	'is_assigned_field'	=>	"BOOL NOT_NULL DEFAULT 0",
	'issues_id_counter'	=>	"INT NOT_NULL DEFAULT 0",
	'issues_id_prefix'	=>	"VARCHAR(20) NULL",
	'rss_item_title'	=>	"VARCHAR(80) NULL",
	'rss_item_desc'	=>	"VARCHAR(80) NULL",
	'rss_count'	=>	"INT NOT_NULL DEFAULT 20",
	'codename'	=>	"VARCHAR(30) NULL",
	'plugin_name'	=>	"VARCHAR(255) NULL",
	'description_simple'	=>	"CLOB NULL",
	'description_rich'	=>	"CLOB NULL",
	'search_form_fields'	=>	"CLOB NULL",
	'search_columns'	=>	"INT NULL DEFAULT 2",
	'def_notifications'	=>	"INT NOT_NULL DEFAULT 0",
	'issues_primary_field'	=>	"VARCHAR(80) NULL DEFAULT NULL",
	'project_icon'	=>	"VARCHAR(40) NULL DEFAULT NULL",
	'project_icon_color'	=>	"VARCHAR(7) NULL DEFAULT NULL",
	'thankyou_page_display_condition'	=>	"INT NOT_NULL DEFAULT 0",
	'thankyou_page_type'	=>	"INT NOT_NULL DEFAULT 1",
	'thankyou_page_content'	=>	"CLOB NULL",
	'private_notes'	=>	"BOOL NULL DEFAULT 0",
	'from_address'	=>	"VARCHAR(255) NULL",
);

$db->CreateTable('hd_project', $table_descr, true);


$all_columns_str = join(', ', array_keys($table_descr));

$query = "INSERT INTO hd_project ($all_columns_str) SELECT $all_columns_str FROM hd_project_bak";

if ($db->type() == 'mssql')
	$db->query("SET IDENTITY_INSERT hd_project ON; $query; SET IDENTITY_INSERT hd_project OFF");
else
	$db->query($query);

list($new_cnt) = $db->query_row("SELECT COUNT(1) FROM hd_project");
list($old_cnt) = $db->query_row("SELECT COUNT(1) FROM hd_project_bak");

if ($new_cnt === $old_cnt)
	$db->DropTable('hd_project_bak');
else
{
	$message = "ERROR! Number of IC projects has changed during migration. The old table 'hd_project_bak' is left for analysis";
	$message .= "\nQuery:\n".$query;
	$migrations->Log($message);
	echo $message."\n";
}

DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('27.07');
