<?php
$_db_migration_to = '34.01'; // 8.8.0-rc
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_news_rename_default.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

use Claromentis\Core\DAL;

/*
 * Update the default channel name 'default' to 'General'.
 */
$result = $db->query('SELECT channel_name
				FROM news_channel
				WHERE id eq:int:id
				AND channel_name eq:str:name',
	1,
	'default'
);

if ($result->hasData())
{
	$query = new DAL\QueryUpdate(
		"news_channel",
		"id eq:int:id",
		[
			"str:channel_name" => 'General'
		]
	);
	$query->Bind("id", 1);
	$db->query($query);
}

DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('34.01');
