<?php
$_db_migration_to = '35.01'; // 8.9.0-rc
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_gallery_comments.php', <<<'DB_UPDATE_FILE'
<?php

/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

// The gallery aggregation was being used for image comments so change the stored aggregations
$db->query('UPDATE discussions SET aggregation = 144 WHERE aggregation = 15');

DB_UPDATE_FILE
);


$migrations->Run('01_update_default_notification_method.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */

use Claromentis\Core\Config\ConfigFile;

$config = $migrations->GetConfigFull();

$method = $config->Get('cfg_default_notification_method');

$const_IM = 2;
$const_EMAIL = 4;
$const_DIGEST_DAILY = 8;
$const_DIGEST_WEEKLY = 16;
$const_DIGEST_MONTHLY = 32;

if (!is_numeric($method))
{
	$method = strtolower($method);

	$convert = [
		"im" => $const_IM,
		"im+email" => $const_IM | $const_EMAIL,
		"email" => $const_EMAIL,
		"digest-d" => $const_DIGEST_DAILY,
		"digest-w" => $const_DIGEST_WEEKLY,
		"digest-m" => $const_DIGEST_MONTHLY
	];

	if (array_key_exists($method, $convert))
	{
		$method = $convert[$method];
	} else
	{
		$method = 0;
	}

	$config->Set('cfg_default_notification_method', $method);
	$config->Save();
}

DB_UPDATE_FILE
);


$migrations->Run('02_create_directories.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$data_dir = $migrations->GetDataDir();

$dirs = ["import", "export"];

foreach ($dirs as $dir)
	if (!is_dir($data_dir . "/$dir"))
		mkdir($data_dir . "/$dir");

DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('35.01');
