<?php
$_db_migration_to = '41.05'; // 10.1.3
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('240207_bt-4476_index_migration_reimplement.php', <<<'DB_UPDATE_FILE'
<?php

/**
 * BT-4476 Tickets loading time optimizations in IC
 *
 * Reimplemented in core v9 during merge forward from v8.13
 *
 * @var \Claromentis\Setup\SetupFacade $migrations
 */
$db = $migrations->GetDb();
$logger = $migrations->getLogger();

// Create indexes to improve loading time for tickets loading time in IC
try {
	$db->CreateIndex('hd_issue', 'idx_project_id_in_project', 'project_id', 'id_in_project');
} catch (\Throwable $throwable) {
	$logger->warning($throwable->getMessage());
	$logger->debug($throwable);
}

DB_UPDATE_FILE
);


$migrations->Run('20250727_add_column_orgchart_OC-30.php', <<<'DB_UPDATE_FILE'
<?php

/**
 * OC-30 add column to `org_chart_department`
 *
 * Reapplied late; was missing from Core 10.1.2
 *
 * @var \Claromentis\Setup\SetupFacade $migrations
 */
$db = $migrations->GetDb();

try {
	// add a new column (Mssql won't ALTER a new column without default value)
	$db->AddColumn('org_chart_department', 'show_disabled_users', 'INT NOT_NULL DEFAULT 1');
} catch (\Throwable $throwable) {
	$logger = $migrations->getLogger();
	$logger->warning($throwable->getMessage());
	$logger->debug($throwable);
}

DB_UPDATE_FILE
);


$migrations->Run('20250801_1_stats_optimize_query_BT-4810.php', <<<'DB_UPDATE_FILE'
<?php

/**
 * BT-4810 Optimize query in `StatsReporter::GetDataVisits()`
 *
 * Reapplied for v10.
 *
 * @var \Claromentis\Setup\SetupFacade $migrations
 */
$db = $migrations->GetDb();
$logger = $migrations->getLogger();

try {
	// add a new column (Mssql won't ALTER anew column without default value)
	$db->AddColumn('stat_visits', 'day_group', 'INT NOT_NULL DEFAULT 0');
} catch (\Throwable $throwable) {
	$logger->warning($throwable->getMessage());
	$logger->debug($throwable);
}

try {
	// improve StatReporter::GetDataVisits()
	$db->CreateIndex('stat_visits', 'idx_date_time_start_session', 'date_time_start', 'session_key');
	// improve StatReporter::GetAverageTimeOnSite()
	$db->CreateIndex('stat_visits', 'idx_day_group', 'day_group');
} catch (\Throwable $throwable) {
	$logger->warning($throwable->getMessage());
	$logger->debug($throwable);
}

// Precompute day_group so we don't have to compute this for each row
$db->query('UPDATE stat_visits SET day_group = FLOOR(date_time_start / 1000000)');

DB_UPDATE_FILE
);


$migrations->Run('20250801_2_index_stat_views_BT-4810.php', <<<'DB_UPDATE_FILE'
<?php

/**
 * BT-4810 Optimize query in `StatsReporter::GetActionsCount()`
 *
 * @var \Claromentis\Setup\SetupFacade $migrations
 */
$db = $migrations->GetDb();
$logger = $migrations->getLogger();

try {
	// The method StatReporter::GetActionsCount() is called multiple times in the StatPluginContentProvider::GetModuleSummaryTemplateData()
	// adding the index will improve the loading page time significantly
	$db->CreateIndex('stat_views', 'idx_aggregation_date_time', 'aggregation', 'date_time');
	$db->CreateIndex('stat_updates', 'idx_aggregation_date_time', 'aggregation', 'date_time');
} catch (\Throwable $throwable) {
	$logger->warning($throwable->getMessage());
	$logger->debug($throwable);
}

DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('41.05');
