<?php
namespace Claromentis\Core\User\Directory\Ldap;

$GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"] = (@$GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"] ?: array()) + array("_178966c8ede126c06" . "bf5e5cc26ef9bb3" => base64_decode("Tm90IGFu" . "IExEQVAg" . "dXNlcg=="), "_28c85ce81fee65329802628" . "93b6f2425" => base64_decode("dXNlc" . "m5hbW" . "U="), "_9d799ff313bcf1dd5c17f0" . "04da40f231" => base64_decode("VXNlc" . "iA="), "_53e519c06eb01660e367876c" . "dd8385f2" => base64_decode("ZX" . "h0" . "X2" . "lk"), "_7f628626dd1d55c71b1fc0932ffd1d2" . "c" => base64_decode("aXNfYXJy" . "YXk="), "_aed8da0f19091214b78f" . "80351048517c" => base64_decode("c3RybG" . "Vu"), "_c230c83684d3ea" . "5d367c6d86c16c0" . "431" => base64_decode("eC11c" . "2Vybm" . "FtZQ=" . "="), "_094a90ab5fdba7fad8a6b3c2c72" . "87bbf" => base64_decode("bnQ0X2R" . "vbWFpbg" . "=="), "_5ff1b1d66ba406be918cf9d21d" . "95d870" => base64_decode("TERBUCBlcnJvcj" . "og"), "_cdcf6e94ff" . "c095d29538c" . "4824c1dba56" => base64_decode("ZGU" . "="), "_211bd0cc9464" . "721ec13058e6b" . "5a9a591" => base64_decode("dXNlcnByaW5jaXB" . "hbG5hbWU="), "_4278f6e1f1" . "e27cc1e9676" . "3e4620a4ff5" => base64_decode("Y21fZG" . "ll"), "_4e306db4c4" . "be96ad112eb" . "80084bb9348" => base64_decode("VGhpcyBhY2NvdW50" . "IGRvZXMgbm90IGJl" . "bG9uZyB0byBhIHVz" . "ZXI="), "_f73dab606630b388645c4f7d3fbb13" . "bb" => base64_decode("YXJyYXlfbWVyZ2U" . "="), "_4298577e41894" . "bcce23f896cd36" . "5aea4" => base64_decode("ZW" . "4="), "_8ff0e2c6dc53989c3" . "7139dd673c9ef80" => base64_decode("XA" . "=="), "_a591754a8ddcdbda9c80f1db4d911" . "e14" => base64_decode("aXNfbn" . "VsbA=="), "_a9148efa986a9a8d8f1f5281c6edf4" . "9e" => base64_decode("VXNlciBhY2NvdW50IGlzIGRpc2FibGVkIGluIE" . "xEQVA="), "_f9544f667576e" . "e583b77d092152" . "97691" => base64_decode("c3RyaXBv" . "cw=="), "_64f204efc0caf630ef68bca56" . "8adbb53" => base64_decode("ZXh0X3" . "R5cGU="), "_e608e5b5c4c34a6" . "7ba97ef84c1e1619" . "9" => base64_decode("J" . "w" . "=" . "="), "_8f65c3c384b" . "75d89f9c7783" . "d4ebd4f32" => base64_decode("bGRhcF9leHBsb2R" . "lX2Ru"), "_c96c5a266f" . "91484f929b4" . "333093dcede" => base64_decode("RW1wdHk" . "gdXNlcm" . "5hbWUh"), "_d155d43a39de93f858123c6b" . "6ce31d8a" => base64_decode("cHJlZ19tYXRjaA" . "=="), "_81166ff3e9c179025b16a3404e7f77" . "58" => base64_decode("RmFpbGVkIHRvIGdldCBzdGFuZGFyZCB1c2VybmFtZS" . "Bmcm9tIHByb3BlcnRpZXMgJ3VzZXJwcmluY2lwYWxu" . "YW1lJyBhbmQgJw=="), "_7a6839269cdf25d875660c6a857fb" . "f8d" => base64_decode("L1tcZFx3XSs9W1xkXHddK" . "yQv"), "_c906bc81dd" . "9c0320ede9a" . "60004ee65af" => base64_decode("d2luMjAwMF9" . "kb21haW4="), "_af50df82a057b10a621d47" . "6dcfd58b99" => base64_decode("IWdyb" . "3Vwcw" . "=="), "_70979d287fa2" . "c98d21aa07834" . "c259a52" => base64_decode("c3RydG9sb3dlcg" . "=="), "_ca5863bab59c" . "c6beb91e24291" . "044d42a" => base64_decode("bWVtYmVyb2" . "Y="), "_4592b1201713114a11390e0bb87e6" . "80d" => base64_decode("ZG4" . "="), "_4d707fab9" . "3bebb00bbe" . "69e8159697" . "c90" => base64_decode(""), "_12223d821ca33ae8d28c" . "4447e3eaf058" => base64_decode("Tm8gdXNlcm5hbWU" . "gZ2l2ZW4="), "_1bee3d4d1d0df49e0fcf8b9ed2" . "ecb8fa" => base64_decode("ZXhwb" . "G9kZQ" . "=="), "_7957e500bc" . "50ac1b8f4c2" . "1b31f14575c" => base64_decode("QmluZFVzZXI6IGJpbmRpb" . "mcgdG8gZGlyZWN0b3J5IG" . "Nvbm5lY3Rpb24gYXMg"), "_e4cff6b52204dc5" . "9b3dc7f210b3150d" . "3" => base64_decode("IGlzIG5vdCBhIG1lbWJlciB" . "vZiBhbGxvd2VkIExEQVAgZ3" . "JvdXAocykgYW5kIE9Vcw=="), "_d706c160e45bf74" . "34fff82a5976f0e1" . "9" => base64_decode("YXJyYXlfa2V5cw=" . "="), "_9777893780444e799e6e71df9" . "31556d0" => base64_decode("R2V0VXNlckROIHVzZXJuYW1lOi" . "A="), "_ef0abf4494e1bd7519b5603ea9" . "e241fc" => base64_decode("RmFpbGVkIHRvIGxvZ2luIHRvIExEQV" . "Agc2VydmVyOiA="), "_ef19287a2ea5e1fa7552d942c14" . "752f9" => base64_decode("eC1k" . "bg=="));
use Claromentis\Core\User\Directory\DirectorySettings;
use Claromentis\Core\User\Directory\Exception\LdapBindFailedException;
use Claromentis\Core\User\Directory\Exception\LdapLogicException;
use Claromentis\Core\User\Directory\Exception\LdapOperationException;
use Claromentis\Core\User\Directory\Exception\LdapUserNotAllowedException;
use Claromentis\Core\User\Directory\Exception\UnsupportedUserTypeException;
use Claromentis\Core\User\Directory\Exception\UsersDirectoryException;
use Claromentis\Core\User\Directory\ExternalUserInfo;
use Claromentis\Core\User\Directory\Ldap\Container\ContainerGroup;
use Claromentis\Core\User\Directory\Ldap\Container\ContainerOU;
use Claromentis\Core\User\Directory\Ldap\Container\ContainersCollection;
use Claromentis\Core\User\Directory\Ldap\Container\UsersContainerInterface;
use Claromentis\Core\User\Directory\UserDateProviderInterface;
use Claromentis\Core\User\Directory\UsersDirectoryInterface;
use CryptUtils;
use Exception;
use Psr\Log\LoggerAwareInterface;
use Psr\Log\LoggerAwareTrait;
use Psr\Log\LoggerInterface;
use Psr\Log\NullLogger;
use User;








class LdapDirectory implements UsersDirectoryInterface, UserDateProviderInterface, LoggerAwareInterface
{
    use LoggerAwareTrait;
    const DIRECTORY_TYPE = 'ldap';
    const DEFAULT_DATE_FORMAT = 'YmdHis.0\\Z';
    const DEFAULT_DATE_WITHOUT_YEAR_FORMAT = 'm-d';
    
    
    
    
    protected $data_parser;
    
    
    
    
    protected $config;
    
    
    
    
    protected $ldap_settings;
    
    
    
    
    protected $connection;
    
    
    
    
    protected $dir_key;
    protected static $groups_rid_cache = null;
    
    
    
    
    protected $name_translate = null;
    public function __construct(LdapSettings $_f56e92e2b328797520a80ee0c4fb95c5, string $_4cf5e7200d92ab57a631fec17739af9b, DataParserInterface $_a4b96b27e3b10c1a4523813f13b9343d, LoggerInterface $logger = null)
    {
        $this->ldap_settings = $_f56e92e2b328797520a80ee0c4fb95c5;
        $this->setLogger($logger ?? new NullLogger());
        $this->connection = new LdapDirectConnection($this->ldap_settings->server_url, [], $this->logger);
        $this->connection->SetServiceAccount($this->ldap_settings->user, $this->ldap_settings->password);
        $this->data_parser = $_a4b96b27e3b10c1a4523813f13b9343d;
        $this->dir_key = $_4cf5e7200d92ab57a631fec17739af9b;
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function FetchExternalUserInfo(ExternalUserInfo $_b038d88c53d0ea3f6bc6c39a6fc77646)
    {
        $_c031077013afa9973ad3516e1ad65118 = $this->GetUserDn($_b038d88c53d0ea3f6bc6c39a6fc77646);
        $_ab45cd2ff0b3084c7533a223b3b093e1 = $this->GetLDAPUserInfo($_c031077013afa9973ad3516e1ad65118, true);
        $_c031077013afa9973ad3516e1ad65118 = $_ab45cd2ff0b3084c7533a223b3b093e1[$GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_ef19287a2ea5e1fa" . "7552d942c14752f9"]];
        $this->EnsureUserAllowed($_c031077013afa9973ad3516e1ad65118);
        $_b038d88c53d0ea3f6bc6c39a6fc77646->ext_type = $this->GetDirKey();
        $_b038d88c53d0ea3f6bc6c39a6fc77646->ext_id = $_c031077013afa9973ad3516e1ad65118;
        $_b038d88c53d0ea3f6bc6c39a6fc77646->fields = $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_f73dab606630b388645c4f7d" . "3fbb13bb"]($_b038d88c53d0ea3f6bc6c39a6fc77646->fields, $_ab45cd2ff0b3084c7533a223b3b093e1);
        $_b038d88c53d0ea3f6bc6c39a6fc77646->fields[$GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_64f204efc0caf630ef68bca56" . "8adbb53"]] = [$_b038d88c53d0ea3f6bc6c39a6fc77646->ext_type];
        $_b038d88c53d0ea3f6bc6c39a6fc77646->fields[$GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_53e519c06eb01660e367" . "876cdd8385f2"]] = [$_b038d88c53d0ea3f6bc6c39a6fc77646->ext_id];
    }
    
    
    
    
    
    
    
    
    
    protected function GetUserDn(ExternalUserInfo $_b038d88c53d0ea3f6bc6c39a6fc77646) : string
    {
        $_4a033bdf0ce701c6255d5238633ab2d0 = $_b038d88c53d0ea3f6bc6c39a6fc77646->service_data;
        $this->logger->debug($GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_977789378044" . "4e799e6e71df9" . "31556d0"] . $_b038d88c53d0ea3f6bc6c39a6fc77646->fields[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_28c85ce81fee6532980262" . "893b6f2425"]]);
        $_9961f986823b4be7f5c4cc8379c6b228 = $GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_1bee3d4d1d0df49e0fc" . "f8b9ed2ecb8fa"]($GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_8ff0e2c6dc53989c37" . "139dd673c9ef80"], $_b038d88c53d0ea3f6bc6c39a6fc77646->fields[$GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_28c85ce81" . "fee6532980" . "262893b6f2" . "425"]]);
        if ($GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_70979d287fa2c98d21aa0783" . "4c259a52"]($this->ldap_settings->domain) !== $GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_70979d287fa2c98d21aa07834c25" . "9a52"]($_9961f986823b4be7f5c4cc8379c6b228[0])) {
            throw new UnsupportedUserTypeException($GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_178966c8ede1" . "26c06bf5e5cc2" . "6ef9bb3"]);
        }
        if ($_b038d88c53d0ea3f6bc6c39a6fc77646->ext_type === $this->GetDirKey() && !empty($_b038d88c53d0ea3f6bc6c39a6fc77646->ext_id)) {
            $_c031077013afa9973ad3516e1ad65118 = $_b038d88c53d0ea3f6bc6c39a6fc77646->ext_id;
        } elseif ($GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_7f628626dd1d55c71b1fc093" . "2ffd1d2c"]($_4a033bdf0ce701c6255d5238633ab2d0) && isset($_4a033bdf0ce701c6255d5238633ab2d0[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_ef19287a2" . "ea5e1fa755" . "2d942c1475" . "2f9"]])) {
            $_c031077013afa9973ad3516e1ad65118 = $_4a033bdf0ce701c6255d5238633ab2d0[$GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_ef19287a" . "2ea5e1fa7" . "552d942c1" . "4752f9"]];
        } else {
            $_c031077013afa9973ad3516e1ad65118 = $GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_4d707fab93bebb00bbe69" . "e8159697c90"];
        }
        if ($this->IsDn($_c031077013afa9973ad3516e1ad65118)) {
            return $_c031077013afa9973ad3516e1ad65118;
        }
        if (!empty($_c031077013afa9973ad3516e1ad65118)) {
            $_28c85ce81fee6532980262893b6f2425 = $_c031077013afa9973ad3516e1ad65118;
        } else {
            $_28c85ce81fee6532980262893b6f2425 = $_b038d88c53d0ea3f6bc6c39a6fc77646->GetUsername();
        }
        if ($_28c85ce81fee6532980262893b6f2425 == $GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_4d707fab" . "93bebb00b" . "be69e8159" . "697c90"]) {
            throw new LdapLogicException($GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_c96c5a266f914" . "84f929b4333093" . "dcede"]);
        }
        $_c031077013afa9973ad3516e1ad65118 = $this->GetNameTranslate()->GetUserDN($_28c85ce81fee6532980262893b6f2425);
        return $_c031077013afa9973ad3516e1ad65118;
    }
    
    
    
    
    
    
    
    
    protected function IsDn(string $_9a0b5569f06c8394f7fab90dbd9bc163) : bool
    {
        if ($_9a0b5569f06c8394f7fab90dbd9bc163 === $GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_4d707fab93bebb00bbe69e8" . "159697c90"]) {
            return false;
        }
        return $GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_8f65c3c384b75d89f9c7783d4e" . "bd4f32"]($_9a0b5569f06c8394f7fab90dbd9bc163, false) !== false;
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function CheckPassword($_28c85ce81fee6532980262893b6f2425, $_e0637eee905ebe3938c5da50e3db10d7)
    {
        if (!$this->IsDomainUser($_28c85ce81fee6532980262893b6f2425)) {
            throw new UnsupportedUserTypeException();
        }
        $this->BindUser($_28c85ce81fee6532980262893b6f2425, CryptUtils::RC4($_e0637eee905ebe3938c5da50e3db10d7, $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_4298577e41894bcce23" . "f896cd365aea4"]));
    }
    protected function IsDomainUser($_28c85ce81fee6532980262893b6f2425)
    {
        if ($GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_f9544f667576ee583b7" . "7d09215297691"]($_28c85ce81fee6532980262893b6f2425, $this->ldap_settings->domain . $GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_8ff0e2c6dc53989c37139dd673c9ef8" . "0"]) === 0) {
            return true;
        }
        return false;
    }
    
    
    
    
    
    
    
    
    
    public function GetReadonlyUserProfileFields(User $_24e0e36600d6af77406a44bb618a6253)
    {
        if (!$this->Enabled()) {
            return array();
        }
        $_122532f21c38b4934972bf1659a76920 = $GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_d706c160e45bf7" . "434fff82a5976f0" . "e19"]($this->ldap_settings->fields_map);
        $_122532f21c38b4934972bf1659a76920[] = $GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_28c85ce81fee6" . "532980262893b6" . "f2425"];
        return $_122532f21c38b4934972bf1659a76920;
    }
    
    
    
    
    
    
    public function Enabled()
    {
        return $this->ldap_settings->enabled;
    }
    
    
    
    
    
    
    
    
    
    
    
    protected function GetNameTranslate()
    {
        if ($this->name_translate == null) {
            $this->name_translate = new NameTranslate($this->connection, $this->ldap_settings, $this->logger);
        }
        return $this->name_translate;
    }
    
    
    
    
    
    
    
    
    protected function EnsureConnected()
    {
        
        
        
        $this->connection->Connect();
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function BindUser($_24e0e36600d6af77406a44bb618a6253 = null, $_c09fdb3aaf264bb220f143d800a9afd5 = '')
    {
        $this->connection->Connect();
        $this->logger->debug($GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_7957e500b" . "c50ac1b8f4" . "c21b31f145" . "75c"] . $_24e0e36600d6af77406a44bb618a6253);
        $_fe0e8a022de5ead12d68c99e07c2847d = $GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_a591754a8ddcdbda9c" . "80f1db4d911e14"]($_24e0e36600d6af77406a44bb618a6253);
        if ($GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_a591754a8ddcdbda9c80f1db4d911" . "e14"]($_24e0e36600d6af77406a44bb618a6253)) {
            $_24e0e36600d6af77406a44bb618a6253 = $this->ldap_settings->user;
            $_e0637eee905ebe3938c5da50e3db10d7 = $this->ldap_settings->password;
        } else {
            $_e0637eee905ebe3938c5da50e3db10d7 = CryptUtils::RC4($_c09fdb3aaf264bb220f143d800a9afd5, $GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_cdcf6e94ff" . "c095d29538c" . "4824c1dba56"]);
        }
        if ($this->ldap_settings->bind_by_dn) {
            if ($_24e0e36600d6af77406a44bb618a6253 == $this->ldap_settings->user || $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_d155d43a39de" . "93f858123c6b6" . "ce31d8a"]($GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_7a6839269cdf25d87" . "5660c6a857fbf8d"], $_24e0e36600d6af77406a44bb618a6253)) {
                
                
                $_39db25051c3981e849efcb9dffcfdcf6 = $_24e0e36600d6af77406a44bb618a6253;
            } else {
                $_39db25051c3981e849efcb9dffcfdcf6 = $this->GetNameTranslate()->GetUserDN($_24e0e36600d6af77406a44bb618a6253);
            }
        } else {
            $_cc7a304be0dc5735413298c4ee5847f6 = $this->ParseDomainUserName($_24e0e36600d6af77406a44bb618a6253);
            if ($GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_aed8da0f190912" . "14b78f803510485" . "17c"]($_cc7a304be0dc5735413298c4ee5847f6[$GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_094a90ab5fdba7fad8a6b3c2c7287bb" . "f"]]) > 0) {
                $_39db25051c3981e849efcb9dffcfdcf6 = $_cc7a304be0dc5735413298c4ee5847f6[$GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_094a90ab5fdba7fad8a6b" . "3c2c7287bbf"]] . $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_8ff0e2c6dc53989c37139dd673c9" . "ef80"] . $_cc7a304be0dc5735413298c4ee5847f6[$GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_28c85ce81fee6532980262893b6" . "f2425"]];
            } else {
                $_39db25051c3981e849efcb9dffcfdcf6 = $_cc7a304be0dc5735413298c4ee5847f6[$GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_28c85ce81fee6" . "532980262893b6" . "f2425"]] . $_cc7a304be0dc5735413298c4ee5847f6[$GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_c906bc81dd9c0320ede9a60004e" . "e65af"]];
            }
        }
        if ($_fe0e8a022de5ead12d68c99e07c2847d) {
            $this->connection->SetServiceAccount($_39db25051c3981e849efcb9dffcfdcf6, $_e0637eee905ebe3938c5da50e3db10d7);
        } else {
            try {
                $this->connection->Bind($_39db25051c3981e849efcb9dffcfdcf6, $_e0637eee905ebe3938c5da50e3db10d7);
            } catch (LdapBindFailedException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
                throw new LdapBindFailedException($GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_ef0abf4494e1bd7519b5603ea" . "9e241fc"] . $_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
            }
        }
        return true;
    }
    protected function EnsureConnectedBound()
    {
        $this->EnsureConnected();
    }
    
    
    
    
    protected function GetUsersContainer()
    {
        $_14e7d5dee412ccf516939d1e99c87733 = $this->ldap_settings->groups;
        $_2a2b1a41820d69b88d2dbb547389945d = $this->ldap_settings->ous;
        $_5e4594441b0e531bfd6f0011e0327611 = new ContainersCollection();
        if (!empty($_2a2b1a41820d69b88d2dbb547389945d)) {
            if ($GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_7f628626dd1d55" . "c71b1fc0932ffd1" . "d2c"]($_2a2b1a41820d69b88d2dbb547389945d)) {
                foreach ($_2a2b1a41820d69b88d2dbb547389945d as $_8fe302831dde8820e73faace6fd81b11) {
                    $_2db143885a946a181bb9cfa5c78146c3 = new ContainerOU($this->connection, $this->ldap_settings, $_8fe302831dde8820e73faace6fd81b11, $this->logger);
                    $_5e4594441b0e531bfd6f0011e0327611->AddContainer($_2db143885a946a181bb9cfa5c78146c3);
                }
            } else {
                $_2db143885a946a181bb9cfa5c78146c3 = new ContainerOU($this->connection, $this->ldap_settings, $_2a2b1a41820d69b88d2dbb547389945d, $this->logger);
                $_5e4594441b0e531bfd6f0011e0327611->AddContainer($_2db143885a946a181bb9cfa5c78146c3);
            }
        }
        if (!empty($_14e7d5dee412ccf516939d1e99c87733)) {
            if ($GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"]["_7f628626dd1d55c71b1fc0932ff" . "d1d2c"]($_14e7d5dee412ccf516939d1e99c87733)) {
                foreach ($_14e7d5dee412ccf516939d1e99c87733 as $_e9208e4fb555ac989f7519e19c1da810) {
                    $_29a0b3613c695dc583f9ee34f00d8187 = new ContainerGroup($this->connection, $this->ldap_settings, $_e9208e4fb555ac989f7519e19c1da810, $this->logger);
                    $_5e4594441b0e531bfd6f0011e0327611->AddContainer($_29a0b3613c695dc583f9ee34f00d8187);
                }
            } else {
                $_29a0b3613c695dc583f9ee34f00d8187 = new ContainerGroup($this->connection, $this->ldap_settings, $_14e7d5dee412ccf516939d1e99c87733, $this->logger);
                $_5e4594441b0e531bfd6f0011e0327611->AddContainer($_29a0b3613c695dc583f9ee34f00d8187);
            }
        }
        return $_5e4594441b0e531bfd6f0011e0327611;
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    protected function EnsureUserAllowed($_c031077013afa9973ad3516e1ad65118)
    {
        $_e84a1b9eb8ec9d4f0cea0b9b922bdf62 = $this->GetUsersContainer();
        if (!$_e84a1b9eb8ec9d4f0cea0b9b922bdf62->IsMember($_c031077013afa9973ad3516e1ad65118)) {
            throw new LdapUserNotAllowedException($GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_9d799ff3" . "13bcf1dd5" . "c17f004da" . "40f231"] . $_c031077013afa9973ad3516e1ad65118 . $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_e4cff6b52" . "204dc59b3d" . "c7f210b315" . "0d3"]);
        }
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    protected function GetLDAPUserInfo($_24e0e36600d6af77406a44bb618a6253, $_69faa59f62ba3f97a51512e4e7236db9 = false)
    {
        $_8e4f4231f852f06b05789873e3eb14eb = $this->GetRawUserInfo($_24e0e36600d6af77406a44bb618a6253, $_69faa59f62ba3f97a51512e4e7236db9);
        $_147aa65e6f86b03cd87a88a580320c7e = $this->GetUserInfoFromRaw($_8e4f4231f852f06b05789873e3eb14eb);
        if ($this->ldap_settings->map_groups !== null && $this->ldap_settings->map_groups != LdapSettings::GROUP_MAP_DISABLED) {
            $_147aa65e6f86b03cd87a88a580320c7e[$GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_af50df82a057b10a621d476dcfd58b9" . "9"]] = $this->GetUserGroups($_8e4f4231f852f06b05789873e3eb14eb);
        }
        return $_147aa65e6f86b03cd87a88a580320c7e;
    }
    protected function GetUserGroups($_8e4f4231f852f06b05789873e3eb14eb)
    {
        $_8067f2d8e4fa1ba80f660e4b1abc5e3f = isset($_8e4f4231f852f06b05789873e3eb14eb[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_ca5863bab59cc6beb91e24291044d" . "42a"]]) ? $_8e4f4231f852f06b05789873e3eb14eb[$GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_ca5863bab59cc6" . "beb91e24291044d" . "42a"]] : [];
        if (!$_8067f2d8e4fa1ba80f660e4b1abc5e3f) {
            return [];
        }
        $_1f24efd4735b7a11b391147435e7d35d = [];
        switch ($this->ldap_settings->map_groups) {
            case LdapSettings::GROUP_MAP_ENABLED:
                foreach ($_8067f2d8e4fa1ba80f660e4b1abc5e3f as $_74a34a7dc25078df9e146af189ce38fb) {
                    $_ce291a483bd670cf1511d10f93596bb6 = $GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_8f65c3c384b75d89f9c7783d4ebd4f" . "32"]($_74a34a7dc25078df9e146af189ce38fb, 1);
                    if (isset($_ce291a483bd670cf1511d10f93596bb6[0])) {
                        $_1f24efd4735b7a11b391147435e7d35d[] = $_ce291a483bd670cf1511d10f93596bb6[0];
                    }
                }
                break;
            case LdapSettings::GROUP_MAP_ENABLED_OU:
                $_8fe302831dde8820e73faace6fd81b11 = $this->ldap_settings->map_groups_expression;
                foreach ($_8067f2d8e4fa1ba80f660e4b1abc5e3f as $_74a34a7dc25078df9e146af189ce38fb) {
                    $_0c92cd3347f4e1cd8b2c48fbd1c2964d = $GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_f9544f667576ee583b" . "77d09215297691"]($_74a34a7dc25078df9e146af189ce38fb, $_8fe302831dde8820e73faace6fd81b11);
                    if ($_0c92cd3347f4e1cd8b2c48fbd1c2964d === false || $_0c92cd3347f4e1cd8b2c48fbd1c2964d + $GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_aed8da0f" . "19091214b" . "78f803510" . "48517c"]($_8fe302831dde8820e73faace6fd81b11) !== $GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_aed8da0f19" . "091214b78f8" . "0351048517c"]($_74a34a7dc25078df9e146af189ce38fb)) {
                        continue;
                    }
                    $_ce291a483bd670cf1511d10f93596bb6 = $GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_8f65c3c384b75d89f9c7" . "783d4ebd4f32"]($_74a34a7dc25078df9e146af189ce38fb, 1);
                    if (isset($_ce291a483bd670cf1511d10f93596bb6[0])) {
                        $_1f24efd4735b7a11b391147435e7d35d[] = $_ce291a483bd670cf1511d10f93596bb6[0];
                    }
                }
                break;
            case LdapSettings::GROUP_MAP_ENABLED_REGEX:
                $_ff52b0cc081aebf6724dddf29003ec05 = $this->ldap_settings->map_groups_expression;
                foreach ($_8067f2d8e4fa1ba80f660e4b1abc5e3f as $_74a34a7dc25078df9e146af189ce38fb) {
                    $_ce291a483bd670cf1511d10f93596bb6 = $GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_8f65c3c384b75d89f9c" . "7783d4ebd4f32"]($_74a34a7dc25078df9e146af189ce38fb, 1);
                    if (!isset($_ce291a483bd670cf1511d10f93596bb6[0])) {
                        continue;
                    }
                    if ($GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_d155d43a3" . "9de93f8581" . "23c6b6ce31" . "d8a"]($_ff52b0cc081aebf6724dddf29003ec05, $_ce291a483bd670cf1511d10f93596bb6[0])) {
                        $_1f24efd4735b7a11b391147435e7d35d[] = $_ce291a483bd670cf1511d10f93596bb6[0];
                    }
                }
                break;
        }
        return $_1f24efd4735b7a11b391147435e7d35d;
    }
    
    
    
    
    
    
    
    protected function GetUserInfoFromRaw($_dbdfe9ef6c70506bf0730dfd58ea52a0)
    {
        try {
            return $this->data_parser->GetDataFromRaw($_dbdfe9ef6c70506bf0730dfd58ea52a0, $this->ldap_settings);
        } catch (Exception $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            $GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_4278f6e1f1e27cc1e96763e4" . "620a4ff5"]($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage());
            return null;
            
            
        }
    }
    
    
    
    
    
    
    
    
    
    protected function GetPropertyValue($_ff02a3ae2d972df289e22f96c7b89ce4, $_dbdfe9ef6c70506bf0730dfd58ea52a0)
    {
        try {
            return $this->data_parser->GetValueByExpression($_dbdfe9ef6c70506bf0730dfd58ea52a0, $_ff02a3ae2d972df289e22f96c7b89ce4);
        } catch (Exception $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            $GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_4278f6e1f" . "1e27cc1e96" . "763e4620a4" . "ff5"]($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage());
            return null;
            
            
        }
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function GetRawUserInfo($_c060acb51130a54b61ab31ad8bbac121, $_69faa59f62ba3f97a51512e4e7236db9 = false)
    {
        static $last_found_user = null;
        static $last_found_dn = null;
        static $last_found_user_info = null;
        if ($_c060acb51130a54b61ab31ad8bbac121 == $GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_4d707fab93bebb00bbe69e" . "8159697c90"]) {
            throw new LdapLogicException($GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_12223d821ca33ae8d28c4447e3e" . "af058"], 24);
        }
        if ($last_found_user == $_c060acb51130a54b61ab31ad8bbac121 || $last_found_dn == $_c060acb51130a54b61ab31ad8bbac121) {
            return $last_found_user_info;
        }
        try {
            $this->EnsureConnectedBound();
            if (!$_69faa59f62ba3f97a51512e4e7236db9) {
                $_4592b1201713114a11390e0bb87e680d = $this->GetNameTranslate()->GetUserDN($_c060acb51130a54b61ab31ad8bbac121);
            } else {
                $_4592b1201713114a11390e0bb87e680d = $_c060acb51130a54b61ab31ad8bbac121;
            }
            $_6aead4bff5639b251aebcf8a630e43a7 = $this->connection->Read($_4592b1201713114a11390e0bb87e680d, $this->ldap_settings->user_type_filter);
            if (!$_6aead4bff5639b251aebcf8a630e43a7) {
                throw new LdapUserNotAllowedException($GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_4e306db4c4be96ad112e" . "b80084bb9348"], 22);
            }
        } catch (LdapUserNotAllowedException $_445ae8a7d426a19b37bd4f87091b7f30) {
            throw $_445ae8a7d426a19b37bd4f87091b7f30;
        } catch (Exception $_445ae8a7d426a19b37bd4f87091b7f30) {
            throw new UsersDirectoryException($GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_5ff1b1d66ba406be918cf9d21d9" . "5d870"] . $_445ae8a7d426a19b37bd4f87091b7f30->getMessage(), $_445ae8a7d426a19b37bd4f87091b7f30->getCode());
        }
        $_d895cb60bf79b51077a88f4cf5d0e6b5 = $this->ldap_settings->user_enabled_filter;
        if ($GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_aed8da0f19091214b78f803510485" . "17c"]($_d895cb60bf79b51077a88f4cf5d0e6b5) > 0) {
            $_371119a328eb895c2d8cf2d55855804e = $this->connection->Read($_4592b1201713114a11390e0bb87e680d, $_d895cb60bf79b51077a88f4cf5d0e6b5);
            if (!$_371119a328eb895c2d8cf2d55855804e) {
                throw new LdapUserNotAllowedException($GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_a9148efa986a9a8d8f1f5281c6edf4" . "9e"], 25);
            }
        }
        $_16c3b779dbe80d626e0d3710d09590fe = $this->ldap_settings->username_field;
        if (isset($_6aead4bff5639b251aebcf8a630e43a7[$GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_70979d287fa2c98d21aa0783" . "4c259a52"]($_16c3b779dbe80d626e0d3710d09590fe)])) {
            $_22b288e3b4e428769d167bb848c14cd0 = $_6aead4bff5639b251aebcf8a630e43a7[$GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_70979d287fa2c98d21aa07834c259" . "a52"]($_16c3b779dbe80d626e0d3710d09590fe)][0];
        } elseif ($GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"]["_aed8da0f19091" . "214b78f8035104" . "8517c"]($_6aead4bff5639b251aebcf8a630e43a7[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_211bd0cc9464721e" . "c13058e6b5a9a591"]][0])) {
            $_22b288e3b4e428769d167bb848c14cd0 = $_6aead4bff5639b251aebcf8a630e43a7[$GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_211bd0cc9464721ec13058e6" . "b5a9a591"]][0];
        } else {
            $_22b288e3b4e428769d167bb848c14cd0 = $_6aead4bff5639b251aebcf8a630e43a7[$_16c3b779dbe80d626e0d3710d09590fe][0];
        }
        if ($GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_aed8da0f19091214b78f" . "80351048517c"]($_22b288e3b4e428769d167bb848c14cd0) == 0) {
            throw new LdapOperationException($GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_81166ff3" . "e9c179025" . "b16a3404e" . "7f7758"] . $_16c3b779dbe80d626e0d3710d09590fe . $GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_e608e5b5c4c34a67ba97" . "ef84c1e16199"]);
        }
        $_6aead4bff5639b251aebcf8a630e43a7[$GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_c230c83" . "684d3ea5" . "d367c6d8" . "6c16c043" . "1"]] = $this->StandardizeUserName($_22b288e3b4e428769d167bb848c14cd0);
        if (!$_69faa59f62ba3f97a51512e4e7236db9) {
            $last_found_user = $_c060acb51130a54b61ab31ad8bbac121;
            $last_found_dn = $_6aead4bff5639b251aebcf8a630e43a7[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_4592b120171311" . "4a11390e0bb87e6" . "80d"]];
        } else {
            $last_found_user = $_6aead4bff5639b251aebcf8a630e43a7[$GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_c230c83684d3ea5d36" . "7c6d86c16c0431"]];
            $last_found_dn = $_c060acb51130a54b61ab31ad8bbac121;
        }
        $last_found_user_info = $_6aead4bff5639b251aebcf8a630e43a7;
        return $_6aead4bff5639b251aebcf8a630e43a7;
    }
    
    
    
    
    
    
    
    
    public function GetConnectionHandler()
    {
        $this->EnsureConnectedBound();
        return $this->connection;
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function ParseDomainUserName($_28c85ce81fee6532980262893b6f2425)
    {
        return $this->GetNameTranslate()->ParseDomainUserName($_28c85ce81fee6532980262893b6f2425);
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    protected function StandardizeUserName($_28c85ce81fee6532980262893b6f2425)
    {
        return $this->GetNameTranslate()->GetNT4Name($_28c85ce81fee6532980262893b6f2425);
    }
    
    
    
    
    
    
    
    public function GetUsersList()
    {
        $this->EnsureConnectedBound();
        $_5e4594441b0e531bfd6f0011e0327611 = $this->GetUsersContainer();
        $_b8f0500f7ec3de46e7358d52b895766a = $_5e4594441b0e531bfd6f0011e0327611->GetMembers();
        $_1519187376d66e1277bb574c97704a93 = [];
        foreach ($_b8f0500f7ec3de46e7358d52b895766a as $_28c85ce81fee6532980262893b6f2425 => $_c031077013afa9973ad3516e1ad65118) {
            $_e040648b744a44c96359dd803b6aa26a = $this->StandardizeUserName($_28c85ce81fee6532980262893b6f2425);
            $_d849cce608c34e14e0534b28c67a6b89 = new ExternalUserInfo($this->GetDirKey(), $_c031077013afa9973ad3516e1ad65118);
            $_d849cce608c34e14e0534b28c67a6b89->SetUsername($_e040648b744a44c96359dd803b6aa26a);
            $_1519187376d66e1277bb574c97704a93[] = $_d849cce608c34e14e0534b28c67a6b89;
        }
        return $_1519187376d66e1277bb574c97704a93;
    }
    
    
    
    
    
    
    
    
    public function UserBelongs(User $_24e0e36600d6af77406a44bb618a6253)
    {
        if (!$this->Enabled()) {
            return false;
        }
        return $_24e0e36600d6af77406a44bb618a6253->GetExtType() == $this->dir_key;
    }
    public function GetDirKey()
    {
        return $this->dir_key;
    }
    public function GetName()
    {
        return $this->ldap_settings->domain;
    }
    
    
    
    
    public function GetDirectorySettings()
    {
        return $this->ldap_settings;
    }
    public function GetDateFormat() : string
    {
        $_d3db06402a34baad2560c7da8a5f9fea = $this->ldap_settings->date_format;
        if (empty($_d3db06402a34baad2560c7da8a5f9fea)) {
            $_d3db06402a34baad2560c7da8a5f9fea = self::DEFAULT_DATE_FORMAT;
        }
        return $_d3db06402a34baad2560c7da8a5f9fea;
    }
    public function GetDateNoYearFormat() : string
    {
        $_256499a511fb5270d7961718f37cf545 = $this->ldap_settings->date_no_year_format;
        if (empty($_256499a511fb5270d7961718f37cf545)) {
            $_256499a511fb5270d7961718f37cf545 = self::DEFAULT_DATE_WITHOUT_YEAR_FORMAT;
        }
        return $_256499a511fb5270d7961718f37cf545;
    }
}