<?php
$_db_migration_to = '25.13'; // 7.4.9
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_design_admin_rename.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations Claromentis\Setup\SetupFacade */
$admin_panel = $migrations->GetAdminPanelCreator();
$admin_panel->Create('design', "/intranet/design/admin.php", array('name' => "Design", 'css_class' => 'icon-tint'));

DB_UPDATE_FILE
);


$migrations->Run('02_IC_private_files.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$db->AddColumn('hd_issue_file', 'is_private', 'BOOL NOT_NULL DEFAULT 0');
$db->AddColumn('hd_issue_file', 'note_id', 'INT');

$files = $db->query('SELECT id, filename, date1 FROM hd_issue_file WHERE note_id IS NULL');
while ($file = $files->fetchArray())
{
	$notes = $db->query('SELECT i_n.id, i_n.issue_id, i_n.private_note FROM hd_issue_note i_n JOIN hd_issue i ON i.id = i_n.issue_id WHERE i_n.date1 = int:date AND (i_n.note LIKE %like:filename% OR i_n.note LIKE %like:filename%)', $file['date1'], '"' . $file['filename'] . '"]', '"]' . $file['filename'] . '[/url]');

	$rows = $notes->numRows();
	if ($rows > 0)
	{
		// Set the file to the first message that matches. Usually only one match will be found.
		$note = $notes->fetchArray();
		$db->query('UPDATE hd_issue_file SET note_id = int:note_id, is_private = int:is_private WHERE id = int:id AND issue_id = int:issue_id', $note['id'], $note['private_note'], $file['id'], $note['issue_id']);
	}
}
DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('25.13');
