<?php
namespace Claromentis\Search\Indexing\Client\Elasticsearch;

$GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"] = (@$GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"] ?: array()) + array("_5159b357296" . "9eca46acd1b2" . "e1418459c" => base64_decode("aW1wb" . "G9kZQ" . "=="), "_8b95086af12ea3e79bb1" . "314de0bdd082" => base64_decode("JyB3aXRob3V0IHByb3ZpZG" . "luZyBhbiBJRA=="), "_f96f38232c31532a" . "01eb2745c51d63cc" => base64_decode("cGlwZWxpbm" . "U="), "_38f12d8b8c719" . "a8ce0fc2faefc2" . "25f35" => base64_decode("YXJyYXlfbWF" . "w"), "_6e6ffa5e4cef62064ccc78bdf7" . "4a203b" => base64_decode("Q2Fubm90IGRlbGV0ZSBmcm9tIHNlYXJjaCBpbmRl" . "eCB0eXBlICc="), "i" . "d" => base64_decode("aWQ" . "="), "_09f61d3133f" . "39f8e5aff0eb" . "6a7d185a1" => base64_decode("ZG" . "9j"), "_02ad47992449" . "51c2d809ee37b" . "e9e79fd" => base64_decode("aW5kZX" . "g="), "_1ac5cc48c34c5362e94d8667cc7b0dd" . "c" => base64_decode("L" . "A" . "=" . "="), "da" . "ta" => base64_decode("ZG" . "F0" . "YQ" . "=="), "_8e89de354d907374" . "1e3902d87bf99b68" => base64_decode("RXhjZXB0aW9" . "uOiA="), "_a591754a8ddcdbd" . "a9c80f1db4d911e1" . "4" => base64_decode("aXNfbnV" . "sbA=="), "_d447517cc97224c765e9" . "183163fe5040" => base64_decode("L" . "Q" . "=" . "="), "_4e7ab34a53ffb13eb083800" . "3f33034d4" => base64_decode("YXR0YWN" . "obWVudH" . "M="), "_f50e845669e7cd06bbc" . "643eeb57aa01d" => base64_decode("Ym9" . "keQ" . "=="));
use Claromentis\Search\Indexing\Client\ClientInterface;
use Claromentis\Search\Indexing\Middleware\Pipeline;
use Claromentis\Search\ItemTypeFactory;
use Elastic\Elasticsearch\Client;
use Psr\Log\LoggerAwareTrait;
use Psr\Log\LoggerInterface;
use Psr\Log\NullLogger;
use Exception;
class ElasticsearchClient implements ClientInterface
{
    use LoggerAwareTrait;
    public const ATTACHMENT_PIPELINE = 'attachment';
    
    
    
    
    public const ATTACHMENT_PIPELINE_DEF = ['id' => 'attachment', "body" => ["processors" => [["attachment" => ["field" => "attachment.data", 'target_field' => 'attachment.info', "if" => "ctx.attachment != null"], "foreach" => ["field" => "attachments", "processor" => ["attachment" => ["target_field" => "_ingest._value.info", "field" => "_ingest._value.data"]], "if" => "ctx.attachments != null"]]]]];
    public const DEFAULT_INDEX_PARAMS = ["settings" => ['analysis' => ['analyzer' => ['filename' => ["type" => "custom", "tokenizer" => "whitespace", "filter" => ["filename_filter", 'file_extension_filter', "lowercase"]]], 'filter' => ['file_extension_filter' => ['type' => 'pattern_capture', 'preserve_original' => true, 'patterns' => [
        "(.*)\\.(?:.*)",
        
        
        "([^\\-_.]+)",
    ]], 'filename_filter' => ['type' => 'word_delimiter', 'preserve_original' => true]]]]];
    private Client $client;
    private ItemTypeFactory $itemTypeFactory;
    private string $indexName;
    private Pipeline $mappingPipeline;
    private Pipeline $indexingPipeline;
    
    
    
    
    
    
    
    
    
    
    
    public function __construct(Client $client, ItemTypeFactory $_b67b64785d0a0ac027d9e8975752a825, string $_7186b8dab67584fd6c4e5b17bfa3c287, Pipeline $_dbe0fd7338f962e46040f518d4c7744b, Pipeline $_88f6cb3cd1fcb832b0d337b4ee3f1ca5, ?LoggerInterface $logger = null)
    {
        $this->client = $client;
        $this->itemTypeFactory = $_b67b64785d0a0ac027d9e8975752a825;
        $this->indexName = $_7186b8dab67584fd6c4e5b17bfa3c287;
        $this->mappingPipeline = $_dbe0fd7338f962e46040f518d4c7744b;
        $this->indexingPipeline = $_88f6cb3cd1fcb832b0d337b4ee3f1ca5;
        $this->setLogger($logger ?? new NullLogger());
    }
    
    
    
    
    
    public function CreateIndex($params = [])
    {
        $_2e5fd271fda00a16d3201b16d65f393d = $this->itemTypeFactory->GetAllIndexingTypes();
        foreach ($_2e5fd271fda00a16d3201b16d65f393d as $_02ad4799244951c2d809ee37be9e79fd) {
            $_7186b8dab67584fd6c4e5b17bfa3c287 = $this->GetIndex($this->indexName, $_02ad4799244951c2d809ee37be9e79fd);
            if ($this->IndexExists($_7186b8dab67584fd6c4e5b17bfa3c287)) {
                $this->client->indices()->delete([$GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_02ad479" . "9244951c" . "2d809ee3" . "7be9e79f" . "d"] => $_7186b8dab67584fd6c4e5b17bfa3c287]);
            }
        }
        try {
            $this->client->ingest()->getPipeline([$GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["i" . "d"] => self::ATTACHMENT_PIPELINE]);
        } catch (Exception $e) {
            $this->client->ingest()->putPipeline(self::ATTACHMENT_PIPELINE_DEF);
        }
    }
    
    
    
    
    
    
    public function GetIndex(string $_02ad4799244951c2d809ee37be9e79fd, ?string $type = null) : string
    {
        if (!empty($type)) {
            $_02ad4799244951c2d809ee37be9e79fd .= $GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_d447517cc97224c765e91831" . "63fe5040"] . $type;
        } else {
            $_02ad4799244951c2d809ee37be9e79fd = $this->GetJoinedIndexes();
        }
        return $_02ad4799244951c2d809ee37be9e79fd;
    }
    
    
    
    
    
    protected function IndexExists(string $_02ad4799244951c2d809ee37be9e79fd) : bool
    {
        $response = $this->client->indices()->exists([$GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_02ad4799244951c2d809ee37be9e7" . "9fd"] => $_02ad4799244951c2d809ee37be9e79fd]);
        return $response->asBool();
    }
    
    
    
    
    
    
    public function Delete($type, $_659d58952a47b6b120f3d1d57caf3476)
    {
        $params = $this->FillParams($type, $_659d58952a47b6b120f3d1d57caf3476, []);
        if (empty($params[$GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["i" . "d"]])) {
            $this->logger->error($GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_6e6ffa5e4" . "cef62064cc" . "c78bdf74a2" . "03b"] . $type . $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_8b95086" . "af12ea3e" . "79bb1314" . "de0bdd08" . "2"]);
            return false;
        }
        try {
            $this->client->delete($params);
        } catch (Exception $e) {
            $this->logger->error($GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_8e89de354d9073741e3902d" . "87bf99b68"] . $e->getMessage(), [$e, $e->getTrace()]);
            return false;
        }
    }
    
    
    
    
    
    
    
    
    public function Index($type, $_659d58952a47b6b120f3d1d57caf3476, $_572ecbe92dff0ba7eb2a689f8c0b1436, $params = [])
    {
        if (isset($_572ecbe92dff0ba7eb2a689f8c0b1436[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_4e7ab34a53ffb13eb08380" . "03f33034d4"]])) {
            $params[$GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_f96f38232c3" . "1532a01eb274" . "5c51d63cc"]] = self::ATTACHMENT_PIPELINE;
        }
        if (isset($_572ecbe92dff0ba7eb2a689f8c0b1436[$GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_4e7ab34a53ff" . "b13eb0838003f" . "33034d4"]][$GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["da" . "ta"]])) {
            $_572ecbe92dff0ba7eb2a689f8c0b1436[$GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_4e7ab34a53ffb13eb0838003f33034" . "d4"]] = [$_572ecbe92dff0ba7eb2a689f8c0b1436[$GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_4e7ab34a53ffb13eb0838003f330" . "34d4"]]];
        }
        
        
        try {
            $params = $this->FillParams($type, $_659d58952a47b6b120f3d1d57caf3476, $params);
            $params[$GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_02ad479" . "9244951c" . "2d809ee3" . "7be9e79f" . "d"]] = $this->GetIndex($this->indexName, $type);
            $params[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_f50e845669e7cd06bbc643eeb57aa01" . "d"]] = $this->indexingPipeline->handle($type, $_572ecbe92dff0ba7eb2a689f8c0b1436);
            return $this->client->index($params)->asArray();
        } catch (Exception $e) {
            $this->logger->error($GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"]["_8e89de35" . "4d9073741" . "e3902d87b" . "f99b68"] . $e->getMessage(), [$e, $e->getTrace()]);
            return false;
        }
    }
    
    
    
    
    
    
    public function AddMapping($type, $params)
    {
        $_02ad4799244951c2d809ee37be9e79fd = $this->GetIndex($this->indexName, $type);
        if ($this->IndexExists($_02ad4799244951c2d809ee37be9e79fd)) {
            $this->client->indices()->delete([$GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_02ad47992" . "44951c2d80" . "9ee37be9e7" . "9fd"] => $_02ad4799244951c2d809ee37be9e79fd]);
        }
        $this->client->indices()->create([$GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"]["_02ad4799244951c2d809ee37be9e7" . "9fd"] => $_02ad4799244951c2d809ee37be9e79fd, $GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_f50e845669e7cd06bbc643e" . "eb57aa01d"] => self::DEFAULT_INDEX_PARAMS]);
        $this->client->indices()->putMapping([$GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_02ad4799244951c2d809ee37be9e79" . "fd"] => $_02ad4799244951c2d809ee37be9e79fd, $GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_f50e84566" . "9e7cd06bbc" . "643eeb57aa" . "01d"] => $this->mappingPipeline->handle($type, $params)]);
    }
    
    
    
    
    
    
    public function DeleteByQuery($type, $query)
    {
        try {
            $params = [$GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_02ad4799244951c" . "2d809ee37be9e79f" . "d"] => $this->GetIndex($this->indexName, $type), $GLOBALS["__65da1b1ec2d6653e" . "8a0ab7848e536215"]["_f50e845" . "669e7cd0" . "6bbc643e" . "eb57aa01" . "d"] => $query];
            $this->client->deleteByQuery($params);
        } catch (Exception $e) {
            $this->logger->error($GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_8e89de354d9073741e3902d87bf" . "99b68"] . $e->getMessage(), [$e, $e->getTrace()]);
            return false;
        }
    }
    
    
    
    
    
    
    
    
    public function Update($type, $_659d58952a47b6b120f3d1d57caf3476, $_572ecbe92dff0ba7eb2a689f8c0b1436, $params = [])
    {
        try {
            $_5c5b1fc550a4fed78ee55566db3f75cd = $this->FillParams($type, $_659d58952a47b6b120f3d1d57caf3476, $params);
            if (!$GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_a591754a8ddcdbda9c80f1db4d911e1" . "4"]($_659d58952a47b6b120f3d1d57caf3476)) {
                $_5c5b1fc550a4fed78ee55566db3f75cd[$GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["i" . "d"]] = $_659d58952a47b6b120f3d1d57caf3476;
            }
            $_5c5b1fc550a4fed78ee55566db3f75cd[$GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"]["_f50e845669e7cd06bbc643eeb57aa0" . "1d"]] = [$GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_09f61d3133f39f8e5aff0eb6a7d1" . "85a1"] => $_572ecbe92dff0ba7eb2a689f8c0b1436];
            return $this->client->update($params)->asArray();
        } catch (Exception $e) {
            $this->logger->error($GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_8e89de3" . "54d90737" . "41e3902d" . "87bf99b6" . "8"] . $e->getMessage(), [$e, $e->getTrace()]);
            return false;
        }
    }
    
    
    
    
    
    
    
    private function FillParams($type, $_659d58952a47b6b120f3d1d57caf3476, array $params = []) : array
    {
        $params[$GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_02ad479" . "9244951c" . "2d809ee3" . "7be9e79f" . "d"]] = $this->GetIndex($this->indexName, $type);
        if (!$GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_a591754a8ddc" . "dbda9c80f1db4" . "d911e14"]($_659d58952a47b6b120f3d1d57caf3476)) {
            $params[$GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["i" . "d"]] = $_659d58952a47b6b120f3d1d57caf3476;
        }
        return $params;
    }
    
    
    
    
    
    private function GetJoinedIndexes(array $_2e5fd271fda00a16d3201b16d65f393d = [])
    {
        if (empty($_2e5fd271fda00a16d3201b16d65f393d)) {
            $_2e5fd271fda00a16d3201b16d65f393d = $this->itemTypeFactory->GetAllIndexingTypes();
        }
        $_7186b8dab67584fd6c4e5b17bfa3c287 = $this->indexName;
        return $GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_5159b3572969eca46a" . "cd1b2e1418459c"]($GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"]["_1ac5cc48c34c5362e94d8667cc7b0dd" . "c"], $GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_38f12d8b8c719a8ce0fc" . "2faefc225f35"](function ($item) use($_7186b8dab67584fd6c4e5b17bfa3c287) {
            return $_7186b8dab67584fd6c4e5b17bfa3c287 . $GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_d447517c" . "c97224c76" . "5e9183163" . "fe5040"] . $item;
        }, $_2e5fd271fda00a16d3201b16d65f393d));
    }
}