define([], function () {

    /**
     * Rule class
     * @class
     * @constructor
     * @property {Number} ruleId
     * @property {String} name
     */
    var Rule = function () {
        'use strict';
        this.model = new Rule.Model();
    };

    Rule.Model = function () {
        'use strict';
        this.view = null;
        /**
         * Rule id
         * @private
         * @type {Number}
         */
        this.ruleId = null;

        /**
         * Rule name
         * @private
         * @type {name}
         */
        this.name = null;
    };

    Rule.Model.prototype = (function () {
        'use strict';
        var setView = function (view) {
            this.view = view;
        };
        /**
         * Set object data
         * @private
         * @memberOf Rule
         * @param {Object} data
         */
        var setData = function (data) {
            setName.call(this, data.name);
            setRuleId.call(this, data.rule_id);
        };

        var setName = function (name) {
            this.name = name;
        };

        /**
         * Get rule name
         * @private
         * @memberOf Rule
         * @returns {String}
         */
        var getName = function () {
            if (_.isString(this.name)) {
                return this.name;
            } else {
                return '';
            }
        };

        var setRuleId = function (ruleId) {
            this.ruleId = parseInt(ruleId, 10);
        };

        /**
         * Get rule id
         * @private
         * @memberOf Rule
         * @returns {Number}
         */
        var getRuleId = function () {
            if (_.isNumber(this.ruleId)) {
                return parseInt(this.ruleId, 10);
            } else {
                return NaN;
            }
        };

        return {
            setView: setView,
            /**
             * Initalise object
             * @public
             * @memberOf Rule
             */
            setData: setData,

            /**
             * Get rule name
             * @public
             * @memberOf Rule
             * @returns {String}
             */
            name: getName,

            /**
             * Get rule id
             * @public
             * @memberOf Rule
             * @returns {Number}
             */
            ruleId: getRuleId
        };
    })();

    return Rule;
});