/**
 * A dev tool just to pre-fill the form for you
 *
 * Add <form-fill></form-fill> to top of ldap form to use.
 *
 */
(function () {
	'use strict';

	angular.module('cla.ldap.connections')
		.directive('formFill', formFill);

	formFill.$inject = ['connectionService', 'directoryService', 'attributesService']

	/**
	 *
	 */
	function formFill (connectionService, directoryService, attributesService) {
		return {
			controller: controller,
			controllerAs: 'fill',
			restrict: 'E',
			scope: { },
			template: '<button ng-click="fill.fill()">Pre-fill Form</button>'
		};

		function controller () {

			this.fill = function () {
				connection();
				directories();
				attributes();
			}

			// add server settings to autofill here 
			function connection () {
				connectionService.properties.serverUrl = '';
				connectionService.properties.netbiosName = '';
				connectionService.properties.serviceAccountDN = '';
				connectionService.properties.serviceAccountPass = '';
				connectionService.properties.searchBaseDN = '';
				connectionService.properties.passwordMethod = '';
				connectionService.properties.dnLookupMethod = '';
				connectionService.properties.sysCharset = '';
			}

			// add directory groups to autofill here
			function directories() {
				directoryService.properties.securityGroups.length = 0;
				directoryService.properties.securityGroups.push('');
				directoryService.properties.securityGroups.push('');
				directoryService.properties.securityGroups.push('');
				directoryService.properties.securityGroups.push('');
			}

			function attributes() {
				attributesService.properties.exampleUserDN = '';
			}
		}
	}
}());