/**
 * Holds data on ldap status
 *
 */
(function () {
	'use strict';

	angular.module('cla.ldap.connections')
		.service('statusService', statusService);

	/**
	 *
	 */
	function statusService() {
		var service = {
			properties: {
				enabled: false
			},

			mapNames: mapNames,
			preload: preload
		};

		return service;

		/**
		 * map js names to expected url params
		 */
		function mapNames() {
			return {
				"enabled": service.properties.enabled
			}
		}

		/**
		 * preloads the object with the data passed to this function
		 */
		function preload(data) {
			if (data) {
				angular.extend(service.properties, {
					"enabled": !!data.enabled
				});
			}
		}
	}
}());