define(function () {
    var symNameService = function () {
    };

    symNameService.prototype.bindSection = function (section) {
        var self = this;
        section.expand_trigger.on('click', function () {
            self.showElement(section.expand_trigger, false);
            self.showElement(section.details, true);
        });

        section.shrink_trigger.on('click', function () {
            self.resetSection(section);
        });

        section.unlock_trigger.on('click', function () {
            self.showElement(section.unlock_trigger, false);
            self.setElementReadOnly(section.input, false);
        });
    };

    symNameService.prototype.showElement = function (element, show) {
        if (show === false) {
            element.hide();
        } else {
            element.show();
        }
    };

    symNameService.prototype.setElementReadOnly = function (element, readonly) {
        if (readonly === false) {
            element.prop('readonly', false);
            element.prop('tabindex', 0);
        } else {
            element.prop('readonly', true);
            element.prop('tabindex', -1);
        }
    };

    symNameService.prototype.resetSection = function (section) {
        var self = this;
        self.showElement(section.details, false);
        self.setElementReadOnly(section.input, true);
        self.showElement(section.expand_trigger, true);
        self.showElement(section.unlock_trigger, true);
    };

    symNameService.prototype.createSection = function (section) {
        return {
            section: section,
            input: section.find('.ic_sym_name_input'),
            details: section.find('.ic_sym_name_details'),
            expand_trigger: section.find('.ic_sym_name_details_toggle'),
            shrink_trigger: section.find('.ic_sym_name_reset'),
            unlock_trigger: section.find('.ic_sym_name_details_unlock')
        };
    };

    symNameService.prototype.isReadOnly = function (section) {
        return section.input.attr('readonly') !== 'undefined';
    };

    return new symNameService();
});
