define([
    'jquery',
    'underscore',
    '../../UI/ai/ai_overview/application-template.tmpl',
    '../../UI/ai/ai_overview/citation-template.tmpl'
], function ($, _, applicationTemplate, citationTemplate) {

    var AiSearchOverview = function () {
        var self = this;

        this.SHOW_MORE_TOKEN = '[SHOW_MORE]';

        this.$ai_search = null;
        this.$loader = null;
        this.$content = null;
        this.$inner = null;
        this.$show_more_container = null;
        this.$applications = null;
        this.search_hash = '';

        this.initialize = function (config) {
            self.$ai_search = $('#ai-search');
            self.$loader = self.$ai_search.find('.ai-skeleton');
            self.$content = self.$ai_search.find('.ai-content');
            self.$inner = self.$ai_search.find('.ai-content-inner');
            self.$show_more_container = self.$ai_search.find('.ai-show-more-container');
            self.$applications = self.$ai_search.find('.ai-search-applications');

            self.app_codes = config.app_codes;
            self.search_hash = config.search_hash;

            self.events();
            self.submit();
        };

        this.events = function () {
            self.$show_more_container.on('click', '.ai-show-more', function () {
                var $hidden = self.$inner.find('.ai-show-more-content');

                $hidden.show();
                $hidden.addClass('ai-expanded');

                self.$show_more_container.fadeOut(150, function () {
                    $(this).remove();
                });
            });
        };

        this.showLoading = function (loading) {
            if (loading) {
                self.$content.hide();
                self.$loader.show();
            } else {
                self.$content.show();
                self.$loader.hide();
            }
        };

        this.drawApplications = function (citations) {
            self.$applications.empty();

            var groups = {};
            citations.forEach(function (citation) {
                if (!groups[citation.type]) groups[citation.type] = [];
                groups[citation.type].push(citation);
            });

            for (var type in groups) {
                var $app = $(applicationTemplate({
                    application: self.app_codes[type],
                    citations: groups[type]
                }));

                $app.hover(
                    function () { $(this).find('.ai-hover-menu').stop(true, true).fadeIn(200); },
                    function () { $(this).find('.ai-hover-menu').stop(true, true).fadeOut(200); }
                );

                self.$applications.append($app);
            }
        };

        this.drawOverview = function (overview, citations) {
            var mappedCitations = {};
            citations.forEach(function (c) { mappedCitations[c.id] = c; });

            // Replace all citation IDs with rendered template
            overview = overview.replace(/\[ID:(\d+)\]/g, function(match, id) {
                var citation = mappedCitations[id];
                if (!citation) {
                    return '';
                }

                return citationTemplate({ citation: citation });
            });

            // Handle SHOW_MORE token
            var hasShowMore = overview.indexOf(self.SHOW_MORE_TOKEN) !== -1;
            var beforeShowMore = overview;
            var afterShowMore = '';
            if (hasShowMore) {
                var parts = overview.split(self.SHOW_MORE_TOKEN);
                beforeShowMore = parts[0];
                afterShowMore = parts[1] || '';
                self.$show_more_container.show();
            } else {
                self.$show_more_container.remove();
            }

            var finalHtml = beforeShowMore;
            if (hasShowMore) {
                finalHtml += '<div class="ai-show-more-content">' + afterShowMore + '</div>';
            }

            self.$inner.html(finalHtml);
        };

        this.submit = function () {
            self.showLoading(true);

            $.post('/api/ai/generate-text', {
                module: 'search',
                metadata: {
                    search_hash: self.search_hash
                }
            })
                .done(function (response) {
                    var data = response.text;
                    self.drawApplications(data.citations);
                    self.drawOverview(data.overview, data.citations);
                })
                .fail(function (xhr, status, error) {
                    self.drawOverview(lmsg('search.ai.overview.error'), []);
                })
                .always(function () {
                    self.showLoading(false);
                });
        };
    };

    return new AiSearchOverview();
});
