<?php
namespace Claromentis\Core\Ai\Adapters\Vertex;

$GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"] = (@$GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"] ?: array()) + array("_e2cad529b5b2b661032342010" . "c496554" => base64_decode("L2xvY2F" . "0aW9ucy" . "8="), "_bef1236f88db6b34bcb878fe48142c" . "b6" => base64_decode("aHR0cF9lcnJv" . "cnM="), "_3e258c4e6163007d8094c396476" . "02e7a" => base64_decode("aGV" . "hZG" . "Vyc" . "w=="), "_7215c118ad86983602d" . "b0b431cb9a1e9" => base64_decode("Z2VuZXJhdG" . "VDb250ZW50"), "_db618ca8e79f97b4dff753ec83" . "7942cf" => base64_decode("cHJvamVjdF9pZA=" . "="), "_6ee75f9f44b14f240f" . "c54f3e19e7084a" => base64_decode("UmVjZWl2ZWQgYW4gdW5leHBlY3RlZCBlcnJvciBmcm9tIHRoZSBzZXJ2" . "ZXI="), "_7681c2a2b7e1bdf6" . "9c23c6cd64114ad3" => base64_decode("anNvbl9kZWNvZGU" . "="), "_67a3498b1e8fe53ddf3" . "9e400a59bc91f" => base64_decode("cmVna" . "W9uX2" . "5hbWU" . "="), "_29225c3f2cb" . "4b5bb8cdfeca" . "d11c6f491" => base64_decode("O" . "g" . "=" . "="), "_f24852a7b2e8c180d1f" . "7ab216c8e8222" => base64_decode("QmVhcmVyI" . "A=="), "_043583fc6e" . "4063be6ec4a" . "31bf951616c" => base64_decode("L3Byb2" . "plY3Rz" . "Lw=="), "_63a6ec2f" . "204402852" . "32bed955b" . "e33266" => base64_decode("c3RyZWFtR2VuZXJhd" . "GVDb250ZW50"), "_7c819f403b3" . "1525f384e33c" . "0142be9f4" => base64_decode("L3B1Ymxpc2hlcnMv" . "Z29vZ2xlL21vZGVs" . "cy8="), "_86e718deafc5b7c86aa6379" . "9a9e024d0" => base64_decode("aHR0cHM6Ly" . "8="), "_e9181de682eebf636bae" . "0512695b2a95" => base64_decode("QXV0aG9yaX" . "phdGlvbg=="), "_8ec8f26c742278f90615f50d682eea7" . "9" => base64_decode("UE" . "9T" . "VA" . "=="), "_b673c9549489ba1916c266f60d" . "c846a8" => base64_decode("cHJlZGlj" . "dA=="), "_47ee521cf7" . "9c60b97cda9" . "ecd9c595c95" => base64_decode("U2VydmVyIHJldHVybmVkIGFuI" . "HVuZXhwZWN0ZWQgcmVzcG9uc2" . "UuIEhUVFAgY29kZTog"), "_1cc5aa2f679b575f82786a73f0da28" . "f8" => base64_decode("c3RyZ" . "WFt"), "_38021ae38952751baca9f63ac2bf723" . "b" => base64_decode("LWFpcGxhdGZvcm0uZ" . "29vZ2xlYXBpcy5jb2" . "0vdjE="), "_0cb031e3cd6ff0075d3b" . "ccfcfdb999a6" => base64_decode("LCBjb" . "250ZW" . "50OiA" . "="));
use Claromentis\Core\Ai\Adapters\Vertex\Requests\Embedding\VertexAiTextEmbeddingRequest;
use Claromentis\Core\Ai\Adapters\Vertex\Requests\Image\VertexAiImageRequest;
use Claromentis\Core\Ai\Adapters\Vertex\Requests\Text\VertexAiTextRequest;
use Claromentis\Core\Ai\Adapters\Vertex\Requests\VertexAiClientAuthentication;
use Claromentis\Core\Ai\Adapters\Vertex\Responses\Image\VertexAiGenerateImageResponse;
use Claromentis\Core\Ai\Adapters\Vertex\Responses\Embedding\VertexAiGenerateTextEmbeddingResponse;
use Claromentis\Core\Ai\Adapters\Vertex\Responses\Text\VertexAiGenerateTextResponse;
use Claromentis\Core\Ai\Exceptions\AiException;
use Claromentis\Core\Ai\Exceptions\AiInvalidRequestException;
use Claromentis\Core\Ai\Exceptions\AiServerResponseException;
use Claromentis\Core\Ai\Exceptions\VertexAiPromptException;
use Claromentis\Core\Ai\JsonParser;
use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\RequestOptions;
use GuzzleHttp\Stream\StreamInterface;
use Psr\Log\LoggerAwareInterface;
use Psr\Log\LoggerAwareTrait;
use Psr\Log\LoggerInterface;
use Psr\Log\NullLogger;
use Symfony\Component\HttpFoundation\Response;






class VertexAiClient implements LoggerAwareInterface
{
    use LoggerAwareTrait;
    
    
    
    
    
    
    
    
    
    public const ERROR_INVALID_ARGUMENT = Response::HTTP_BAD_REQUEST;
    public const ERROR_UNAUTHENTICATED = Response::HTTP_UNAUTHORIZED;
    public const ERROR_PERMISSION_DENIED = Response::HTTP_FORBIDDEN;
    public const ERROR_NOT_FOUND = Response::HTTP_NOT_FOUND;
    public const ERROR_RESOURCE_EXHAUSTED = Response::HTTP_TOO_MANY_REQUESTS;
    public const ERROR_CANCELLED = 499;
    
    
    public const ERROR_INTERNAL_ERROR = Response::HTTP_INTERNAL_SERVER_ERROR;
    public const ERROR_UNAVAILABLE = Response::HTTP_SERVICE_UNAVAILABLE;
    public const ERROR_DEADLINE_EXCEEDED = Response::HTTP_GATEWAY_TIMEOUT;
    
    
    
    
    private string $projectId;
    
    
    
    
    private string $regionName;
    
    
    
    
    private string $modelName;
    
    
    
    
    private VertexAiClientAuthentication $authentication;
    
    
    
    
    private ClientInterface $client;
    
    
    
    
    
    
    
    
    
    public function __construct(VertexAiClientAuthentication $_961ccc1b377e30c70011809b405b9c07, array $config, LoggerInterface $logger = null, ClientInterface $_2f664bcc4a0a32ffda2885fb12940265 = null)
    {
        $this->projectId = $config[$GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_db618ca8e7" . "9f97b4dff75" . "3ec837942cf"]];
        $this->regionName = $config[$GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_67a3498b1e" . "8fe53ddf39e" . "400a59bc91f"]];
        $this->authentication = $_961ccc1b377e30c70011809b405b9c07;
        $this->logger = $logger ?? new NullLogger();
        $this->client = $_2f664bcc4a0a32ffda2885fb12940265 ?? new Client();
    }
    
    
    
    
    
    
    
    
    
    
    public function handleGenerateTextRequest(VertexAiTextRequest $request, ?callable $_5c51b0e4b7267b43adabf8015a8e1cf8 = null)
    {
        
        
        $this->modelName = $request->getModelName();
        $_f4bd77b9d7574792bd46db73586ce19d = $request->serialize();
        if ($request->isStreaming()) {
            $this->generateTextStream($_f4bd77b9d7574792bd46db73586ce19d, $_5c51b0e4b7267b43adabf8015a8e1cf8);
            return;
        }
        return $this->generateText($_f4bd77b9d7574792bd46db73586ce19d);
    }
    
    
    
    
    
    
    
    
    
    public function handleTextEmbeddingRequest(VertexAiTextEmbeddingRequest $request)
    {
        
        
        $this->modelName = $request->getModelName();
        $_f4bd77b9d7574792bd46db73586ce19d = $request->serialize();
        return $this->generateTextEmbedding($_f4bd77b9d7574792bd46db73586ce19d);
    }
    
    
    
    
    
    
    
    
    
    public function handleGenerateImageRequest(VertexAiImageRequest $request)
    {
        
        
        
        $this->modelName = $request->getModelName();
        $_f4bd77b9d7574792bd46db73586ce19d = $request->serialize();
        return $this->generateImages($_f4bd77b9d7574792bd46db73586ce19d);
    }
    
    
    
    
    
    
    
    private function generateText(array $data) : VertexAiGenerateTextResponse
    {
        $_3bf6f785d3520dfd17a871d18d745880 = $GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"]["_7215c118ad869" . "83602db0b431cb" . "9a1e9"];
        $_c927258f5322288a992c77be40ae0b53 = $this->buildURL($_3bf6f785d3520dfd17a871d18d745880);
        return VertexAiGenerateTextResponse::fromArray($GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_7681c2a2b7e1bdf69c23c6c" . "d64114ad3"]($this->send($_c927258f5322288a992c77be40ae0b53, $data), true), $this->modelName);
    }
    
    
    
    
    
    
    
    private function generateTextEmbedding(array $data) : VertexAiGenerateTextEmbeddingResponse
    {
        $_3bf6f785d3520dfd17a871d18d745880 = $GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_b673c9549489ba1916c2" . "66f60dc846a8"];
        $_c927258f5322288a992c77be40ae0b53 = $this->buildURL($_3bf6f785d3520dfd17a871d18d745880);
        return VertexAiGenerateTextEmbeddingResponse::fromArray($GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"]["_7681c2a2b7e1bdf69c23c6cd64114a" . "d3"]($this->send($_c927258f5322288a992c77be40ae0b53, $data), true), $this->modelName);
    }
    
    
    
    
    
    
    
    private function generateImages(array $data) : VertexAiGenerateImageResponse
    {
        $_3bf6f785d3520dfd17a871d18d745880 = $GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_b673c9549489ba1916c266f60" . "dc846a8"];
        $_c927258f5322288a992c77be40ae0b53 = $this->buildURL($_3bf6f785d3520dfd17a871d18d745880);
        return VertexAiGenerateImageResponse::fromArray($GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_7681c2a2b7e1bdf69c23c6cd64114a" . "d3"]($this->send($_c927258f5322288a992c77be40ae0b53, $data), true));
    }
    
    
    
    
    
    
    
    public function buildURL(string $_3bf6f785d3520dfd17a871d18d745880) : string
    {
        return $GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"]["_86e718deafc5b7c86aa63799a9e" . "024d0"] . $this->regionName . $GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"]["_38021ae38952751baca9" . "f63ac2bf723b"] . $GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_043583fc6e4063be6ec4a31bf9" . "51616c"] . $this->projectId . $GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_e2cad529b5b2b661032342" . "010c496554"] . $this->regionName . $GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_7c819f40" . "3b31525f3" . "84e33c014" . "2be9f4"] . $this->modelName . ($GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_29225c3f2cb4b5bb8cdfecad11" . "c6f491"] . $_3bf6f785d3520dfd17a871d18d745880);
    }
    
    
    
    
    
    
    
    
    
    
    
    private function send(string $_c927258f5322288a992c77be40ae0b53, array $data, bool $_1cc5aa2f679b575f82786a73f0da28f8 = false)
    {
        $_fd5a3a643834299cbdadfc3540ba0bcb = $this->client->request($GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_8ec8f26c742278f90615f50d682ee" . "a79"], $_c927258f5322288a992c77be40ae0b53, [RequestOptions::JSON => $data, $GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_1cc5aa2f679b575f8" . "2786a73f0da28f8"] => $_1cc5aa2f679b575f82786a73f0da28f8, $GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_bef1236f88db6b34bcb878fe48142" . "cb6"] => false, $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_3e258c4e6" . "163007d809" . "4c39647602" . "e7a"] => [$GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_e9181de682eebf636bae0512695b" . "2a95"] => $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_f24852a7b2e8c180" . "d1f7ab216c8e8222"] . $this->authentication->getAccessToken()]]);
        $this->checkResponse($_fd5a3a643834299cbdadfc3540ba0bcb);
        return $_fd5a3a643834299cbdadfc3540ba0bcb->getBody();
    }
    
    
    
    
    
    
    
    
    private function generateTextStream(array $data, callable $_5c51b0e4b7267b43adabf8015a8e1cf8) : void
    {
        $_3bf6f785d3520dfd17a871d18d745880 = $GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_63a6ec2f2044028" . "5232bed955be3326" . "6"];
        $_c927258f5322288a992c77be40ae0b53 = $this->buildURL($_3bf6f785d3520dfd17a871d18d745880);
        $_1cc5aa2f679b575f82786a73f0da28f8 = $this->send($_c927258f5322288a992c77be40ae0b53, $data, true);
        $_c37f5d387ecde7a206c24852e173b2fe = new JsonParser(function (array $_fd62bc4eaaf7d58dea9bada3e30443b9) use($_5c51b0e4b7267b43adabf8015a8e1cf8) {
            $_5c51b0e4b7267b43adabf8015a8e1cf8(VertexAiGenerateTextResponse::fromArray($_fd62bc4eaaf7d58dea9bada3e30443b9, $this->modelName));
        });
        while (!$_1cc5aa2f679b575f82786a73f0da28f8->eof()) {
            $_c37f5d387ecde7a206c24852e173b2fe->consume($_1cc5aa2f679b575f82786a73f0da28f8->Read(1024));
        }
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    private function checkResponse(\Psr\Http\Message\ResponseInterface $_fd5a3a643834299cbdadfc3540ba0bcb)
    {
        switch ($_fd5a3a643834299cbdadfc3540ba0bcb->getStatusCode()) {
            
            
            
            case self::ERROR_UNAUTHENTICATED:
            case self::ERROR_PERMISSION_DENIED:
                throw AiException::invalidCredentials();
            case self::ERROR_INVALID_ARGUMENT:
                $_d55fb2699e58134ae2c2fa8c7340298b = (string) $_fd5a3a643834299cbdadfc3540ba0bcb->getBody();
                throw new AiInvalidRequestException();
            case self::ERROR_NOT_FOUND:
            case self::ERROR_RESOURCE_EXHAUSTED:
            case self::ERROR_CANCELLED:
            case self::ERROR_DEADLINE_EXCEEDED:
            case self::ERROR_INTERNAL_ERROR:
            case self::ERROR_UNAVAILABLE:
                $this->logger->error($GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_47ee521cf79c60b97cda9ecd" . "9c595c95"] . $_fd5a3a643834299cbdadfc3540ba0bcb->getStatusCode() . $GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_0cb031e3cd6ff0" . "075d3bccfcfdb99" . "9a6"] . $_fd5a3a643834299cbdadfc3540ba0bcb->getBody());
                throw new AiServerResponseException($GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_6ee75f9f44b14f240fc5" . "4f3e19e7084a"], $_fd5a3a643834299cbdadfc3540ba0bcb->getStatusCode());
        }
    }
}