<?php
$_db_migration_to = '41.07'; // 10.3.0
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('20240617_comments_acknowledgement.php', <<<'DB_UPDATE_FILE'
<?php

/**
 * FRAM-968 Comments Acknowledgement
 *
 * @var \Claromentis\Setup\SetupFacade $migrations
 */
$db = $migrations->GetDb();

// Add column to store flag with acknowledgement per comment
$db->AddColumn('discussions', 'acknowledgement', 'BOOL NOT_NULL DEFAULT 0');

// store acknowledgement per user and object
$table_descr = [
	'id'		  	=> "IDENTITY",
	'discussion_id' => "INT NOT_NULL",
	'user_id'	 	=> "INT NOT_NULL",
	'timestamp'	  	=> "INT_DATE NULL",
];

$db->CreateTable('discussions_acknowledgements', $table_descr, true);
$db->CreateIndex('discussions_acknowledgements', 'discussions_acknowledgements_discussion_user_id', 'discussion_id', 'user_id');

DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('41.07');
