(function()
{
	var moduleName = 'commentsModule';

	angular.module(moduleName)
	.service('commentWidthService', commentWidthService);

	function commentWidthService()
	{
		var service = this;
		var width = 600;
		var watchers = [];

		service.setWidth = function(width)
		{
			service.width = width;

			// Tell anyone who cares
			for (var i = 0; i < watchers.length; i++)
			{
				watchers[i].trigger('comment-container-resized');
			}
		};

		service.getWidth = function()
		{
			return service.width;
		};

		service.watch = function($element)
		{
			watchers.push($element);
		};
	}
}());