<?php
namespace Claromentis\Design\Facade;

$GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"] = (@$GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"] ?: array()) + array("_31767d7ad" . "58e706dbf4" . "7b7a51a0fe" . "6c4" => base64_decode("Y291bnQ" . "="), "_bd71c3b5c201fc11d" . "b82ed14ce424de5" => base64_decode("aW5fYX" . "JyYXk="), "cod" . "e" => base64_decode("Y29k" . "ZQ=="), "_2af0ef5713f30a95e42939a799871e" . "98" => base64_decode("U0VMRUNUIERJU1RJTkNUIGNvZGUsI" . "HByaW9yaXR5IEZST00gdGhlbWUgT1" . "JERVIgQlkgcHJpb3JpdHk="), "_c12b64435f67e2188a71f87d8a45fff" . "7" => base64_decode("U0VMRUNUIERJU1RJTkNUIGlkLCBjb2RlLCBwcmlvcml0eSBGUk9NIHRoZW1lIE" . "9SREVSIEJZIHByaW9yaXR5"), "_995c85e296ce8fb695" . "21bdc6de9deb25" => base64_decode("Y3VycmVudA" . "=="), "_bfbc77a5f7ea6a0ff8d8aecf" . "e6402a94" => base64_decode("cmV" . "zZX" . "Q="));
use Claromentis\Core\DAL;
use Claromentis\Core\Repository\Exception\NotFoundException;
use Claromentis\Core\Security\SecurityContext;
use Claromentis\Design\Model\Theme;
use Claromentis\Design\Repository\ThemeRepository;
use Claromentis\Design\ThemeAcl;




class UserThemes
{
    protected $db;
    protected $acl;
    protected $theme_repo;
    public function __construct(DAL\Db $db, ThemeAcl $acl, ThemeRepository $theme_repo)
    {
        $this->db = $db;
        $this->acl = $acl;
        $this->theme_repo = $theme_repo;
    }
    public function GetAvailableForced($user_id = -1)
    {
        $_4c8189237e0d0b5cd82c06d69613c88e = new DAL\QueryBuilder($GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"]["_c12b6443" . "5f67e2188" . "a71f87d8a" . "45fff7"]);
        $this->acl->ApplyForcedPermissions($_4c8189237e0d0b5cd82c06d69613c88e, $user_id);
        $_4c8189237e0d0b5cd82c06d69613c88e->SetLimit(1);
        $_189840d11056515e52402d1412a0b6e4 = $this->db->query($_4c8189237e0d0b5cd82c06d69613c88e->GetQuery());
        $_facbfadfe0905845e8361332b94e8d45 = [];
        while ($_343a395319323dd7609bcbc465b4d034 = $_189840d11056515e52402d1412a0b6e4->fetchArray()) {
            $_facbfadfe0905845e8361332b94e8d45[] = $_343a395319323dd7609bcbc465b4d034[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["co" . "de"]];
        }
        return $_facbfadfe0905845e8361332b94e8d45;
    }
    public function GetAvailableNormal($user_id = -1)
    {
        $_4c8189237e0d0b5cd82c06d69613c88e = new DAL\QueryBuilder($GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_2af0ef5713f30a95" . "e42939a799871e98"]);
        $this->acl->ApplyViewPermissions($_4c8189237e0d0b5cd82c06d69613c88e, $user_id);
        $_189840d11056515e52402d1412a0b6e4 = $this->db->query($_4c8189237e0d0b5cd82c06d69613c88e->GetQuery());
        $_facbfadfe0905845e8361332b94e8d45 = [];
        while ($_343a395319323dd7609bcbc465b4d034 = $_189840d11056515e52402d1412a0b6e4->fetchArray()) {
            $_facbfadfe0905845e8361332b94e8d45[] = $_343a395319323dd7609bcbc465b4d034[$GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["cod" . "e"]];
        }
        return $_facbfadfe0905845e8361332b94e8d45;
    }
    public function GetAvailable($user_id = -1)
    {
        $user_id = (int) $user_id;
        $themes = $this->GetAvailableForced($user_id);
        if ($GLOBALS["__65da1b1ec2d6653e8" . "a0ab7848e536215"]["_31767d7ad58e706dbf47b7a51a0f" . "e6c4"]($themes) > 0) {
            return $themes;
        }
        $themes = $this->GetAvailableNormal($user_id);
        return $themes;
    }
    
    
    
    
    
    
    public function GetPreferred(SecurityContext $context)
    {
        $_66632ba13f0bd92d0364ec09f29705f7 = $this->GetAvailable();
        if (empty($_66632ba13f0bd92d0364ec09f29705f7)) {
            return null;
        }
        $GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_bfbc77a5f7ea" . "6a0ff8d8aecfe" . "6402a94"]($_66632ba13f0bd92d0364ec09f29705f7);
        return $GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_995c85e296ce8fb69521bd" . "c6de9deb25"]($_66632ba13f0bd92d0364ec09f29705f7);
    }
    
    
    
    
    
    
    
    public function IsAllowed(SecurityContext $context, $theme_code)
    {
        $_66632ba13f0bd92d0364ec09f29705f7 = $this->GetAvailable();
        return $GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"]["_bd71c3b5c201fc11d" . "b82ed14ce424de5"]($theme_code, $_66632ba13f0bd92d0364ec09f29705f7);
    }
    public function GetIdByCode($code)
    {
        try {
            $theme = $this->theme_repo->GetByCode($code);
        } catch (NotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            return 0;
        }
        return $theme->id;
    }
    public function GetCodeById($theme_id)
    {
        try {
            $theme = $this->theme_repo->Get($theme_id);
            
            
        } catch (NotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            return null;
        }
        return $theme->GetCode();
    }
    public function SetForUser($theme_code, \User $_24e0e36600d6af77406a44bb618a6253)
    {
        $_24e0e36600d6af77406a44bb618a6253->SetSkin($theme_code);
        $_24e0e36600d6af77406a44bb618a6253->Save();
    }
    
    
    
    
    
    
    public function GetByCode($code)
    {
        try {
            $theme = $this->theme_repo->GetByCode($code);
            
            
        } catch (NotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            return null;
        }
        return $theme;
    }
}