angular.module('doclink', [])
    .directive('claDocLink', function ()
    {
        var control_name = 'doc';
        var TYPE_DOC = 2;

        return {
            restrict: 'E',

            scope: {},
            bindToController: {
                link: '=', // 2 way binding
				controlToken: '=' // 2 way binding
            },
            controllerAs: 'cdl',

            compile: function ()
            {
                // modify ids for document tree viewer specific ids
                angular.element("#doc_id").attr({id: control_name + "_special_id"});
                angular.element("#doc_name").attr({id: control_name + "_realname"});
            },

            /**
             * Controller
             */
            controller: function ()
            {
				var ctrl = this;

                this.$onInit = function() {
                    ctrl.reset();

                    ctrl.token = ctrl.controlToken || {};
                    ctrl.token.resetDocLink = function()
                    {
                        ctrl.reset();
                    }
                };

                ctrl.reset = function()
				{
					ctrl.link = {
						'doc_id': 0,
						'original': '',
						'type': TYPE_DOC // PHP Attachment::TYPE_DOC
					};
				};

                ctrl.open = function ()
                {
                    // resides in /intranet/common/file_upload_control.js
                    callFolderTreePopup(control_name, 0);
                    return false;
                };
            },

            templateUrl: '/intranet/comments/html/ui/doc_link.html'
        }
    });
