/**
 * Action for popup menu shown when a document/folder is clicked
 */
var InfoMenuActionsView = Backbone.View.extend({
	all_actions: [],
	collection: null,

	initialize: function ()
	{
		this.all_actions = [];
		//this.all_actions.push(new DashboardActionView());
		this.all_actions.push(new DashboardActionApprove());
		this.all_actions.push(new DashboardActionViewProperties());
		this.all_actions.push(new DashboardActionEditProperties());
		this.all_actions.push(new DashboardActionDownload());
		//this.all_actions.push(new DashboardActionDownloadZip());
		this.all_actions.push(new DashboardActionCheckout());
		this.all_actions.push(new DashboardActionCheckin());
		this.all_actions.push(new DashboardActionRenew());
		this.all_actions.push(new DashboardActionDelete());
		//this.all_actions.push(new DashboardActionAddBookmark());
		this.all_actions.push(new DashboardActionRemoveBookmark());
		this.all_actions.push(new DashboardActionPermissions());
	},

	renderMenu: function(object, menu_el)
	{
        // Don't show the dropdown menu if there's an error.
        if (!object.get('is_error')) {
            var text;
            this.el = menu_el;
            this.$el = jQuery(this.el);

            this.$el.empty();
            this.$el.hide();

            this.collection = new DocsCollection([object]);

            for (var i = 0; i < this.all_actions.length; i++) {
                var action = this.all_actions[i];
                if (this.collection && action.isAllowed(this.collection)) {
                    text = $('<li class="action_element" data-index="' + i + '">' + action.render(this.collection) + '</li>');
                    $('a', text).removeClass('btn btn-secondary btn btn-sm mr-1 mb-1').removeAttr('rel').addClass('dropdown-item');
                    $('a', text).append(' ' + $('a', text).data('original-title')).removeAttr('data-original-title');
                    this.$el.append(text);
                }
            }
            this.$el.show();
            this.delegateEvents({'click .action_element': "onActionClick"});
        }
	},

	onActionClick: function (event)
	{
		this.el.parents('.documentItem').removeClass('open').find(".dropdown-menu").hide();
		var idx = $(event.currentTarget).data('index');
		var action = this.all_actions[idx];
		if (typeof(action) == 'undefined')
			return true;
		if (typeof(action.click) == 'function')
		{
			return action.click(this.collection);
		}

		return true;
	}
});
