<?php
$_db_migration_to = '33.09'; // 8.7.4
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_update_notification_methods.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

/*
 * This is transforming the old-style sequential ID into the new bitmask.
 *
 * The old system:
 * 1 - IM + push
 * 2 - IM + email + push
 * 3 - Email
 * 4 - Daily digest
 * 5 - Weekly digest
 * 6 - Monthly digest
 *
 * Where the options are mutually exclusive.
 *
 * The new system:
 *
 * 0000 0001 (1)  - Push
 * 0000 0010 (2)  - IM
 * 0000 0100 (4)  - Immediate email
 * 0000 1000 (8)  - Daily digest
 * 0001 0000 (16) - Weekly digest
 * 0010 0000 (32) - Monthly digest
 *
 * Where the bits can be combined. (but combining more than one of the digest bits has an undefined behaviour)
 *
 * So the mapping from old to new is:
 *
 * 1 -> 3  (0000 0011) IM + Push
 * 2 -> 7  (0000 0111) IM + Email + Push
 * 3 -> 4  (0000 0100) Immediate email
 * 3 -> 8  (0000 1000) Daily digest
 * 3 -> 16 (0001 0000) Weekly digest
 * 3 -> 32 (0010 0000) Monthly digest
 *
 * The values set here are 100 more than the bitmask values, so that the replacements do not
 * interfere with each other (eg step 3 would alter rows which had been altered to 3 in step 1)
 * they are then corrected afterward
 */
$db->query("UPDATE users SET notification_method=103 WHERE notification_method=1");
$db->query("UPDATE users SET notification_method=107 WHERE notification_method=2");
$db->query("UPDATE users SET notification_method=104 WHERE notification_method=3");
$db->query("UPDATE users SET notification_method=108 WHERE notification_method=4");
$db->query("UPDATE users SET notification_method=116 WHERE notification_method=5");
$db->query("UPDATE users SET notification_method=132 WHERE notification_method=6");

$db->query("UPDATE im_notification_methods SET notification_method=103 WHERE notification_method=1");
$db->query("UPDATE im_notification_methods SET notification_method=107 WHERE notification_method=2");
$db->query("UPDATE im_notification_methods SET notification_method=104 WHERE notification_method=3");
$db->query("UPDATE im_notification_methods SET notification_method=108 WHERE notification_method=4");
$db->query("UPDATE im_notification_methods SET notification_method=116 WHERE notification_method=5");
$db->query("UPDATE im_notification_methods SET notification_method=132 WHERE notification_method=6");

/*
 * Here we subtract 100 off of the set values to give the correct bitmask value.
 */
$db->query("UPDATE users SET notification_method=notification_method-100");
$db->query("UPDATE im_notification_methods SET notification_method=notification_method-100");

DB_UPDATE_FILE
);


$migrations->Run('02_update_notification_column.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->AlterColumn('users', 'notification_method', 'INT NULL DEFAULT 2');

DB_UPDATE_FILE
);


$migrations->Run('03_fix_silly_mistake.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->AlterColumn('users', 'INT NULL DEFAULT 2', 'notification_method', 'INT NULL DEFAULT 2');
DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('33.09');
