/**
 * Collection that contains all selected (ticked) documents from the current documents list
 */
var ClipboardCollection = SelectedDocsCollection.extend({
	selected_collection: null,

	initialize: function ()
	{
		this.selected_collection = new SelectedDocsCollection();
		this.bind('add', function (obj) {this.selected_collection.add(obj);}, this);
		this.bind('remove', function (obj) {this.selected_collection.remove(obj);}, this);
		this.bind('reset', function () {
			this.selected_collection.reset(null, {silent:true});
			for (var i=0; i < this.length; i++)
			{
				this.selected_collection.add(this.at(i), {silent: true});
			}
		}, this);
	}
});


