var undo = window.undo || {};

var getOrder = function(el) {
	el = $(el);
	var sectionId = el.data('section-id');
	var items = [];
	_.each(el.children('div.js-field-row'), function(row) {
		row = $(row);
		items.push({
			field_id : row.data('field-id'),
			position : row.data('field-position')
		});
	});
	return {
		sectionId : sectionId,
		items : items
	};
};
/**
 * Called by xajax, updates the data attributes after a database has been updated.
 * @param {Object} sectionId
 * @param {Object} fields
 */
var updateDOM = function(sectionId, fields) {
	fields = JSON.parse(fields);
	var section = $('#form_details_tab').find('div[data-section-id="' + sectionId + '"]');
	_.each(fields, function(field) {
		section.find('div[data-field-id="' + field.field_id + '"]').attr('data-field-position', field.position);
	});
};

$(document).ready(function() {
    
	// drag form rows
	$('.ic-section-fields').sortable({
		// handle : 'label',
		axis : 'y',
		delay : 300,
		opacity : '.75',
		placeholder : 'sortable-placeholder',
		start : function(event, ui) {
			var originalOrder = getOrder(event.currentTarget);
			ui.placeholder.height(ui.item.height());
			$(ui.item).data("originalOrder", originalOrder);
		},
		stop : function(event, ui) {
			var newOrder = getOrder(event.target);
			var originalOrder = $(ui.item).data("originalOrder");
			xajax_update_position(originalOrder, newOrder);
			window.undo.originalOrder = originalOrder;
			window.undo.newOrder = newOrder;
			$('#undo_reorder').show();
		}
	});
	$('.ic-section-fields').find('label').disableSelection();
	$('#undo_reorder').on('click', function() {
		xajax_update_position(window.undo.newOrder, window.undo.originalOrder);
		$('.ic-section-fields').sortable('cancel');
		$('#undo_reorder').hide();
	});

    $(":checkbox[name='no_default']").change(function(){
        hideOrShowDropdownCheck();
    });

    $("a[name='wysiwyg_edit']").click(function(){
        hideOrShowDropdownCheck();
    });
    
});

function hideOrShowDropdownCheck()
{
    if($(":checkbox[name='no_default']").length == 0)
        return false;

    if($(":checkbox[name='no_default']").attr('checked')) {
        $("select[name='default_value']").hide();
    }
    else {
        $("select[name='default_value']").show();
    }
}
