document.pr_array = {};

pr_toggle_window = function(id, uniq_code){
	var div = jq_$(id);
	popup_wrap_window(div);
	//if (!div.hasClass('invisible'))
	//	return div.addClass('invisible');

	document.pr_array[uniq_code] = {};
	jQuery(document.body).append(div);
	//pr_position_window(div, uniq_code);

	div.removeClass('invisible');
	pr_keyword_change(uniq_code);
//	if ($defined(jq_$('pr_keyword_'+uniq_code))) $('pr_keyword_'+uniq_code).focus();
};

pr_position_window = function(div, uniq_code){
	var el = jq_$('pr_button_' + uniq_code);
	var coord = el.offset();
	div.css({
		top: coord.top + el.height(),
		left: coord.left
	});
};

pr_keyword_change = function (uniq_code)
{
	if (document.pr_array[uniq_code].timer)
		clearTimeout(document.pr_array[uniq_code].timer);
	document.pr_array[uniq_code].timer = null;
	document.pr_array[uniq_code].timer = setTimeout(function() { pr_start_search(uniq_code); }, 300);
};

pr_start_search = function(uniq_code)
{
	if (document.pr_array[uniq_code].timer)
		clearTimeout(document.pr_array[uniq_code].timer);
	document.pr_array[uniq_code].timer = null;

	var select = jq_$('pr_select_'+uniq_code);
	select.empty().append('<option value="0">...LOADING...</option>');
//	pr_role_get_result.delay(10, this, [$('pr_keyword_'+this.uniq_code).value, this.uniq_code, $('pr_allowed_'+this.uniq_code).value, $('pr_not_allowed_'+this.uniq_code).value] );
	setTimeout(function() { pr_role_get_result(jq_$('pr_keyword_'+uniq_code).val(), uniq_code, jq_$('pr_allowed_'+uniq_code).val(), jq_$('pr_not_allowed_'+uniq_code).val()); }, 10);
};

pr_finish_search = function(role_arr, uniq_code){
	var select = jq_$('pr_select_'+uniq_code);
	select.empty();
	select.dblclick(function(e){pr_add(uniq_code);});

	jQuery(role_arr).each(function(idx, role){
		select.append(jQuery('<option value="'+role[0]+'">'+role[1]+'</option>'));
	});

	if (jQuery(role_arr).length < 1){
		select.append(jQuery('<option value="" disabled="disabled">...no results...</option>'));
	}
};

pr_add = function(uniq_code){
	var arr = [];
	jQuery('#pr_select_'+uniq_code+' option').each(function(idx, option){
		if (option.selected){
			arr.push({'id': option.value, 'name': option.innerHTML, 'can_edit': true});
		}
	});
    window[jq_$('pr_callback_'+uniq_code).val()](arr, uniq_code);
};

pr_add_all = function(uniq_code){
	var arr = [];
	jQuery('#pr_select_'+uniq_code+' option').each(function(idx, option){
		if (!option.disabled){
			arr.push({'id': option.value, 'name': option.innerHTML, 'can_edit': true});
		}
	});
	window[jq_$('pr_callback_'+uniq_code).val()](arr, uniq_code);
};

pr_role_add = function(arr, uniq_code, only_read) {
	jQuery(arr.reverse()).each(function (index, role){
		var el = document.getElementById(uniq_code);
		var role_ids = el.value;
		var arr = role_ids.split(",");
		if (arr && jQuery.inArray(role.id, arr) == -1)
		{
			if (el.value !== undefined)
			{
				if (!el.value)
					el.value = role.id;
				else
					el.value += "," + role.id;
			}

			var row = jq_$(uniq_code + '_template_row').clone();
			row.attr('id', uniq_code + "_" + role.id);

			jq_$(uniq_code + '_template_row').after(row);

			jQuery('td:first', row).text(role.name);

			if (!role.can_edit)
				$('.js-delete', row).hide();

			if (!only_read) {
				jQuery('.js-delete', row).click(function (e) {
					pr_role_remove(role.id,uniq_code,this)
					e.preventDefault();
				});
			}
			row.removeClass('invisible_table_row');
		}
	});
};

pr_role_remove = function(id,uniq_code,el) {
	var role_ids = document.getElementById(uniq_code).value;
	var arr = role_ids.split(",");
	var new_arr = new Array();
	for (i=0;i<arr.length;i++)
	{
	    if (arr[i] != id)
	    {
			new_arr.push(arr[i]);
	    }
	}
	document.getElementById(uniq_code).value = new_arr.toString();
	jq_$(uniq_code + "_" + id).remove();
};

pr_init = function (uniq_code, only_read) {
	if (typeof(only_read) === 'undefined') only_read = 0;
	if (document.getElementById(uniq_code + "_data"))
	{
		var g_arr = eval(document.getElementById(uniq_code + "_data").value);
		pr_role_add(g_arr, uniq_code, only_read);
	}
};
