webpackJsonp_name_([3],{

/***/ "./node_modules/@claromentis/design-system/dist/esm/cla-likes-modal.entry.js":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "cla_likes_modal", function() { return ClaLikesModal; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__index_45215791_js__ = __webpack_require__("./node_modules/@claromentis/design-system/dist/esm/index-45215791.js");
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__utils_063604d2_js__ = __webpack_require__("./node_modules/@claromentis/design-system/dist/esm/utils-063604d2.js");



const ClaLikesModal = class {
  constructor(hostRef) {
    __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__index_45215791_js__["c" /* r */])(this, hostRef);
    /**
     * Items to display per page.
     */
    this.ITEMS_PER_PAGE = 30;
    /**
     * Items per column.
     */
    this.ITEMS_PER_COLUMN = 10;
    /**
     * Maximum pagination items to show.
     */
    this.MAX_PAGES_TO_SHOW = 5;
    /**
     * Current page.
     */
    this.currentPage = 1;
    /**
     * Total pages.
     */
    this.totalPages = 0;
    /**
     * Total likes.
     */
    this.totalLikes = 0;
    /**
     * List of people who liked.
     */
    this.likers = [];
    /**
     * Whether the modal is open.
     */
    this.isOpen = false;
    /**
     * This is used to update the `totalLikes` state.
     */
    this.total = 0;
  }
  /**
   * Update `totalLikes` when component is loaded.
   * Pass the prop to the state
   */
  componentWillLoad() {
    this.totalLikes = this.total;
  }
  /**
   * Teleport the modal to the body after first render
   */
  componentDidRender() {
    if (this.isOpen) {
      const modal = this.element.querySelector('.modal');
      if (modal && document.body.contains(modal)) {
        document.body.appendChild(modal);
      }
    }
  }
  /**
   * Watch the `total` being changed
   * Update `totalLikes` when `total` changes to keep in sync
   *
   * @param {number} newValue New value
   */
  onTotalChange(newValue) {
    this.totalLikes = newValue;
  }
  /**
   * Fetch the likers data
   *
   * @param offset The offset (or current position)
   */
  async fetchData(offset = 0) {
    try {
      let result;
      {
        const response = await fetch(`/api/like/${this.objectType}/${this.objectId}?limit=${this.ITEMS_PER_PAGE}&offset=${offset}`);
        result = await response.json();
      }
      this.likers = result.data;
      this.totalLikes = result.paging.total;
      this.totalPages = Math.ceil(result.paging.total / this.ITEMS_PER_PAGE);
      this.currentPage = Math.floor(result.paging.offset / result.paging.limit) + 1;
      this.isOpen = true;
    }
    catch (error) {
      console.error('Error fetching likers:', error);
    }
  }
  /**
   * Handle page pagination click
   *
   * @param event Event
   * @param page Page
   */
  handlePageClick(event, page) {
    event.preventDefault();
    if (page >= 1) {
      this.currentPage = page;
      this.fetchData((page - 1) * this.ITEMS_PER_PAGE);
    }
  }
  /**
   * Close the modal
   */
  closeModal() {
    this.isOpen = false;
    this.likers = [];
  }
  /**
   * Get the likers per column
   *
   * @param {Number} index
   * @returns {Array}
   */
  getLikersByColumn(index) {
    return this.likers.slice(index * this.ITEMS_PER_COLUMN, (index + 1) * this.ITEMS_PER_COLUMN);
  }
  /**
   * Render the markup
   *
   * @returns {JSX}
   */
  render() {
    return (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__index_45215791_js__["d" /* h */])("div", null, __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__index_45215791_js__["d" /* h */])("a", { href: "#", onClick: (event) => this.handlePageClick(event, 1) }, this.totalLikes, " ", this.totalLikes <= 1 ? __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1__utils_063604d2_js__["a" /* d */])('common.notifications.post_like') : __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1__utils_063604d2_js__["a" /* d */])('common.notifications.post_likes')), this.isOpen && (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__index_45215791_js__["d" /* h */])("div", { class: "modal fade show d-block overflow-auto" }, __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__index_45215791_js__["d" /* h */])("div", { class: "modal-dialog modal-lg" }, __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__index_45215791_js__["d" /* h */])("div", { class: "modal-content" }, __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__index_45215791_js__["d" /* h */])("div", { class: "modal-header" }, __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__index_45215791_js__["d" /* h */])("h5", { class: "modal-title" }, __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__index_45215791_js__["d" /* h */])("span", { class: "mr-3" }, __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1__utils_063604d2_js__["a" /* d */])('common.cla_comments.people_who_liked_this')), __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__index_45215791_js__["d" /* h */])("cla-badge", { slot: "status", styleclass: "badge badge-pill badge-secondary" }, this.totalLikes)), __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__index_45215791_js__["d" /* h */])("cla-button", { class: "close", onClick: () => this.closeModal() }, __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__index_45215791_js__["d" /* h */])("span", { "aria-hidden": "true" }, __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__index_45215791_js__["d" /* h */])("ion-icon", { name: "close-outline" })))), __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__index_45215791_js__["d" /* h */])("div", { class: "modal-body" }, __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__index_45215791_js__["d" /* h */])("div", { class: "row row-col-3" }, [[], [], []].map((_, colIndex) => (this.getLikersByColumn(colIndex).length > 0 && (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__index_45215791_js__["d" /* h */])("div", { class: "col" }, __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__index_45215791_js__["d" /* h */])("ul", { class: "list-group list-group-flush" }, this.likers
      .slice(colIndex * this.ITEMS_PER_COLUMN, (colIndex + 1) * this.ITEMS_PER_COLUMN)
      .map(liker => (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__index_45215791_js__["d" /* h */])("li", { class: "list-group-item" }, __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__index_45215791_js__["d" /* h */])("div", { class: "media align-items-center" }, __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__index_45215791_js__["d" /* h */])("a", { href: liker.profile_link, target: "_blank" }, __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__index_45215791_js__["d" /* h */])("img", { src: liker.profile_photo, alt: "", width: "32", class: "media-object profile-img" })), __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__index_45215791_js__["d" /* h */])("div", { class: "media-body ml-2 text-truncate" }, __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__index_45215791_js__["d" /* h */])("a", { href: liker.profile_link, target: "_blank" }, liker.user_name)))))))))))), this.totalPages > 1 && (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__index_45215791_js__["d" /* h */])("nav", { class: "d-flex justify-content-center", "aria-label": "Likes Modal Pagination" }, __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__index_45215791_js__["d" /* h */])("ul", { class: "pagination" }, __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__index_45215791_js__["d" /* h */])("li", { class: `page-item ${this.currentPage === 1 ? 'disabled' : ''}` }, __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__index_45215791_js__["d" /* h */])("a", { class: "page-link", href: "#", onClick: (event) => this.handlePageClick(event, 1), "aria-label": "First" }, "\u00AB")), __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__index_45215791_js__["d" /* h */])("li", { class: `page-item ${this.currentPage === 1 ? 'disabled' : ''}` }, __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__index_45215791_js__["d" /* h */])("a", { class: "page-link", href: "#", onClick: (event) => this.handlePageClick(event, this.currentPage - 1), "aria-label": "Previous" }, "\u2039")), (() => {
      let startPage = Math.max(1, this.currentPage - Math.floor(this.MAX_PAGES_TO_SHOW / 2));
      let endPage = Math.min(this.totalPages, startPage + this.MAX_PAGES_TO_SHOW - 1);
      if (endPage - startPage < this.MAX_PAGES_TO_SHOW - 1) {
        startPage = Math.max(1, endPage - this.MAX_PAGES_TO_SHOW + 1);
      }
      return [...Array(endPage - startPage + 1)].map((_, index) => {
        const page = startPage + index;
        return (__webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__index_45215791_js__["d" /* h */])("li", { class: `page-item ${page === this.currentPage ? 'active' : ''}` }, __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__index_45215791_js__["d" /* h */])("a", { class: "page-link", href: "#", onClick: (event) => this.handlePageClick(event, page) }, page)));
      });
    })(), __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__index_45215791_js__["d" /* h */])("li", { class: `page-item ${this.currentPage === this.totalPages ? 'disabled' : ''}` }, __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__index_45215791_js__["d" /* h */])("a", { class: "page-link", href: "#", onClick: (event) => this.handlePageClick(event, this.currentPage + 1), "aria-label": "Next" }, "\u203A")), __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__index_45215791_js__["d" /* h */])("li", { class: `page-item ${this.currentPage === this.totalPages ? 'disabled' : ''}` }, __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__index_45215791_js__["d" /* h */])("a", { class: "page-link", href: "#", onClick: (event) => this.handlePageClick(event, this.totalPages), "aria-label": "Last" }, "\u00BB")))))), __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__index_45215791_js__["d" /* h */])("div", { class: "modal-footer d-flex justify-content-center" }, __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__index_45215791_js__["d" /* h */])("button", { type: "button", class: "btn btn-block btn-secondary d-md-inline-block w-md-25 w-100", onClick: () => this.closeModal() }, __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_1__utils_063604d2_js__["a" /* d */])('common.close')))))))));
  }
  get element() { return __webpack_require__.i(__WEBPACK_IMPORTED_MODULE_0__index_45215791_js__["e" /* g */])(this); }
  static get watchers() { return {
    "total": ["onTotalChange"]
  }; }
};




/***/ }),

/***/ "./node_modules/@claromentis/design-system/dist/esm/utils-063604d2.js":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "g", function() { return NodeListForEachIe11; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "h", function() { return claNavInline; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "j", function() { return pickerGroupMultiselect; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "f", function() { return claImgFixed; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return lmsg; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "i", function() { return findItemLabel; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return hasShadowDom; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "k", function() { return isInViewport; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return lightOrDark; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return propagateFocusEvent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "e", function() { return submitClosestForm; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "l", function() { return textWidth; });
/**
 * Submit the closest form in the given element's ancestry.
 *
 * @see https://github.com/ionic-team/ionic/blob/e5c8c10/core/src/components/button/button.tsx#L110-L131
 * @param {HTMLElement} element - The element to submit a form for.
 * @param {string} [type] - The type of form submission. `'reset'` or `'submit'`, defaults to `'submit'`.
 * @param {string} [name] - The name of the button to use for the submission.
 * @param {any} [value] - The value of the button to use for the submission.
 * @return {void}
 */
function submitClosestForm(element, type = 'submit', name, value) {
  if (!element.ownerDocument) {
    return;
  }
  // Find the closest form
  const form = element.closest('form');
  if (!form) {
    return;
  }
  // Create a fake button element
  const fakeButton = element.ownerDocument.createElement('button');
  if (name != null) {
    fakeButton.name = name;
  }
  if (value != null) {
    fakeButton.value = value;
  }
  fakeButton.type = type;
  fakeButton.style.display = 'none';
  // Use the fake button element to submit the form
  form.appendChild(fakeButton);
  fakeButton.click();
  fakeButton.remove();
}
/**
 * Determine whether an element has a Shadow DOM.
 *
 * @see https://github.com/ionic-team/ionic/blob/f9483a0/core/src/utils/helpers.ts#L13-L15
 * @param {HTMLElement} element - The element to detect Shadow DOM for.
 * @return {boolean} - Whether the element has a Shadow DOM.
 */
function hasShadowDom(element) {
  return !!element.shadowRoot && !!element.attachShadow;
}
/**
 * Propagate a focus event on a given element.
 *
 * @param {HTMLElement} element - The element to propagate the focus event on.
 * @param {FocusEvent} event - The focus event to propagate.
 */
function propagateFocusEvent(element, event) {
  element.dispatchEvent(cloneFocusEvent(event));
}
/**
 * Clone a focus event in a way that's compatible with Internet Explorer.
 *
 * @param {FocusEvent} event
 * @return {FocusEvent}
 */
function cloneFocusEvent(event) {
  if (typeof Event === 'function') {
    return new FocusEvent(event.type, { relatedTarget: event.target });
  }
  // // IE
  // let target = event.currentTarget as Element;
  // let eventClone = target.ownerDocument.createEvent('FocusEvent');
  // eventClone.initFocusEvent(event.type, event.bubbles, event.cancelable, event.view, event.detail, event.target);
  //
  // return eventClone;
}
/***
* Polyfill for IE11 missing NodeList.forEach
*/
function NodeListForEachIe11() {
  if ('NodeList' in window && !NodeList.prototype.forEach) {
    NodeList.prototype.forEach = function (callback, thisArg) {
      thisArg = thisArg || window;
      for (var i = 0; i < this.length; i++) {
        callback.call(thisArg, this[i], i, this);
      }
    };
  }
}
/**
 * Finds the cla-label within cla-item
 *
 * @param {HTMLElement} componentEl
 * @return {componentEl.label}
 */
function findItemLabel(componentEl) {
  const itemEl = componentEl.closest('cla-item');
  if (itemEl) {
    return itemEl.querySelector('cla-label');
  }
  return console.error('Error: Please wrap label and corresponding element within a <cla-item>. Refer to readme for details');
}
/**
 * Is the cla-picker-group multiselectable or not
 *
 * @param {HTMLElement} componentEl
 *
 *
 */
function pickerGroupMultiselect(componentEl) {
  const pickerGroup = componentEl.closest('cla-picker-group');
  if (pickerGroup === null) {
    console.error('Error: Please use <cla-picker> within a <cla-picker-group>. Refer to readme for details');
    return false;
  }
  return pickerGroup.getAttribute('multiselectable') === "true";
}
/**
 * Is the cla-nav inline or block
 *
 * @param {HTMLElement} componentEl
 */
function claNavInline(componentEl) {
  const claNav = componentEl.closest('cla-nav');
  return claNav.getAttribute('inline') === "true";
}
/**
 * Is the cla-card-image aspect ratio fixed
 *
 * @param {HTMLElement} componentEl
 */
function claImgFixed(componentEl) {
  const claImg = componentEl.closest('cla-card-media');
  return claImg.getAttribute('preserveaspect') === "true";
}
/***
* check if element is in the viewport
* @param {Element} elem
* @return {boolean} is the element within the viewport?
*/
function isInViewport(elem) {
  var bounding = elem.getBoundingClientRect();
  return (bounding.top >= 0 &&
    bounding.left >= 0 &&
    bounding.bottom <= (window.innerHeight || document.documentElement.clientHeight) &&
    bounding.right <= (window.innerWidth || document.documentElement.clientWidth));
}
/***
* finds the pixel width of text
* @param {String} text
* @return {Integer}
*/
function textWidth(text) {
  const tempSpan = document.createElement('span');
  tempSpan.innerHTML = text;
  document.body.appendChild(tempSpan);
  // Get the width of the span then remove it
  const textWidth = tempSpan.offsetWidth;
  tempSpan.remove();
  return textWidth;
}
/***
 * determines whether a colour value is light or dark
 * @param  HSL, HEX or RGB color
 * @return {String}
 */
function lightOrDark(color) {
  // Variables for red, green, blue values
  let r, g, b, hsp;
  // Check the format of the color, HEX or RGB?
  if (color.match(/^rgb/)) {
    // If HEX --> store the red, green, blue values in separate variables
    color = color.match(/^rgba?\((\d+),\s*(\d+),\s*(\d+)(?:,\s*(\d+(?:\.\d+)?))?\)$/);
    r = color[1];
    g = color[2];
    b = color[3];
  }
  else if (color.match(/^hsl/)) {
    let sep = color.indexOf(",") > -1 ? "," : " ";
    color = color.substr(4).split(")")[0].split(sep);
    let h = color[0], s = color[1].substr(0, color[1].length - 1) / 100, l = color[2].substr(0, color[2].length - 1) / 100, c = (1 - Math.abs(2 * l - 1)) * s, x = c * (1 - Math.abs((h / 60) % 2 - 1)), m = l - c / 2;
    if (0 <= h && h < 60) {
      r = c;
      g = x;
      b = 0;
    }
    else if (60 <= h && h < 120) {
      r = x;
      g = c;
      b = 0;
    }
    else if (120 <= h && h < 180) {
      r = 0;
      g = c;
      b = x;
    }
    else if (180 <= h && h < 240) {
      r = 0;
      g = x;
      b = c;
    }
    else if (240 <= h && h < 300) {
      r = x;
      g = 0;
      b = c;
    }
    else if (300 <= h && h < 360) {
      r = c;
      g = 0;
      b = x;
    }
    r = Math.round((r + m) * 255);
    g = Math.round((g + m) * 255);
    b = Math.round((b + m) * 255);
  }
  else {
    // If RGB --> Convert it to HEX: http://gist.github.com/983661
    color = +("0x" + color.slice(1).replace(color.length < 5 && /./g, '$&$&'));
    r = color >> 16;
    g = color >> 8 & 255;
    b = color & 255;
  }
  // HSP (Highly Sensitive Poo) equation from http://alienryderflex.com/hsp.html
  hsp = Math.sqrt(0.299 * (r * r) +
    0.587 * (g * g) +
    0.114 * (b * b));
  // Using the HSP value, determine whether the color is light or dark
  if (hsp > 127.5) {
    return 'light';
  }
  else {
    return 'dark';
  }
}
/**
 * Localization message.
 *
 * @param {string} key
 * @param {*[]} args
 * @returns
 */
function lmsg(key, ...args) {
  if (!window.lmsg) {
    return key;
  }
  return window.lmsg(key, ...args);
}




/***/ })

});
//# sourceMappingURL=3.js.map