<?php
$_db_migration_to = '25.01'; // 7.4 alpha
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('10_endorsements_table_changes.php', <<<'DB_UPDATE_FILE'
<?php

$db = $migrations->GetDb();

// New table for endorsements.
$table_descr = array(
	'endorser_id'	=>	"INT NOT_NULL DEFAULT 0",
	'endorsee_id'	=>	"INT NOT_NULL DEFAULT 0",
	'skillid'		=>	"INT NOT_NULL DEFAULT 0",
);
$db->CreateTable('endorsements', $table_descr, true);

 //Remove unused skillrolenum column from the skillsdesc table.
$db->DropColumn("skillsdesc", "skillrolenum");


DB_UPDATE_FILE
);


$migrations->Run('11_endorsements_id_column.php', <<<'DB_UPDATE_FILE'
<?php

$db = $migrations->GetDb();

// Adds an id column, needed to removed possible duplicates left by merge.
$db->AddColumn('endorsements', 'id', 'IDENTITY');
DB_UPDATE_FILE
);


$migrations->Run('200_search_query_params.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();


// search_query_params_cache
$table_descr = array(
	'last_used'	=>	"INT_DATE NOT_NULL DEFAULT 0",
	'params'	=>	"CLOB NULL",
	'hash'	=>	"VARCHAR(64) NULL",
	'searchtime'	=>	"FLOAT NULL",
);

$db->CreateTable('search_query_params', $table_descr, true);


DB_UPDATE_FILE
);


$migrations->Run('201_indexing_instruction.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

//$db->AddColumn('indexing_instruction', 'extra', 'VARCHAR_MAX NULL');


$table_descr = array(
	'object_type'  => "VARCHAR(64)",
	'object_id'    => "VARCHAR(255)",
	'sub_id'       => "INT NOT_NULL DEFAULT 0",
	'action'       => "INT NOT_NULL DEFAULT 0",
	'time_added'   => "INT_DATE NOT_NULL DEFAULT 0",
    'extra'        => "VARCHAR_MAX NULL"
);

$db->CreateTable('indexing_queue', $table_descr, true);

DB_UPDATE_FILE
);


$migrations->Run('300_docs_add_parent_and_perms.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$db->AddColumn('ERMS_data', 'parent_id', 'INT NOT_NULL DEFAULT 0');

$db->AddColumn('ERMS_data', 'perm_id', 'INT NOT_NULL DEFAULT 0');
$db->AddColumn('ERMS_file_plan', 'perm_id', 'INT NOT_NULL DEFAULT 0');


DB_UPDATE_FILE
);


$migrations->Run('301_docs_set_parent_id.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

// copy parent_id from ERMS_data_pointer table
if ($db->type() == 'mssql')
{
	$db->query("UPDATE ERMS_data SET parent_id=(SELECT MIN(folder_id) FROM ERMS_data_pointer WHERE ERMS_data_pointer.data_id=ERMS_data.id) WHERE id IN (SELECT data_id FROM ERMS_data_pointer)");
	// copy parent_id for all versions
	$db->query("UPDATE ERMS_data SET parent_id=(SELECT MAX(d2.parent_id) FROM ERMS_data d2 WHERE d2.doc_id=ERMS_data.doc_id)");
} elseif ($db->type() == 'mysql')
{
	$db->query("CREATE TEMPORARY TABLE ERMS_parents AS SELECT d.doc_id doc_id, MIN(dp.folder_id) parent_id FROM ERMS_data_pointer dp, ERMS_data d WHERE dp.data_id=d.id GROUP BY d.doc_id");
	$db->query("CREATE INDEX ERMS_parents_idx ON ERMS_parents (doc_id)");
	$db->query("UPDATE ERMS_data SET parent_id=IFNULL((SELECT parent_id FROM ERMS_parents WHERE ERMS_parents.doc_id=ERMS_data.doc_id), 0)");
	$db->query("DROP TABLE ERMS_parents");
} else
{
	$migrations->Log("ERROR! Unknown database type - ".$db->type());
}

// now there should not be any documents without parent id, but if there are any, moving them into "lost+found" folder
list($lost_docs_count) = $db->query_row("SELECT COUNT(id) FROM ERMS_data WHERE parent_id=0");
if ($lost_docs_count > 0)
{
	$db->query(new \Claromentis\Core\DAL\QueryInsert('ERMS_file_plan', array(
		'str:refcode' => 'lost_found',
	    'str:title' => 'lost+found',
	    'int:date_created' => gmdate('YmdHis'),
	    'int:date_last_modified' => gmdate('YmdHis'),
	    'int:parent_id' => 0,
	    'int:creator' => 1,
	    'int:deleted' => 0,
	    'int:aggregation' => 2, //AGGREGATION_FOLDER
	    'int:perm_id' => 0
	)));

	$new_folder_id = $db->insertId();
	if (!$new_folder_id)
	{
		$migrations->Log("Failed creating lost+found folder");
	} else
	{
		$db->query("UPDATE ERMS_data SET parent_id=int:id, perm_id=0 WHERE parent_id=0", $new_folder_id);
	}
}

DB_UPDATE_FILE
);


$migrations->Run('302_docs_set_perm_id.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();
//$db->trace = 1+4;

// copy perm_id from metadata for folders
if ($db->type() == 'mssql')
	$db->query("UPDATE ERMS_file_plan SET perm_id=COALESCE(
	    (SELECT me.intval FROM ERMS_metadata_link ml LEFT JOIN ERMS_metadata_element me ON ml.element_id=me.id WHERE
	      ml.object_id=ERMS_file_plan.id AND ml.aggregation=2 AND ml.name='permissions'), 0) WHERE refcode<>'lost_found'"); // AGGREGATION_FOLDER=2
elseif ($db->type() == 'mysql')
	$db->query("UPDATE ERMS_file_plan SET perm_id=IFNULL(
	    (SELECT me.intval FROM ERMS_metadata_link ml LEFT JOIN ERMS_metadata_element me ON ml.element_id=me.id WHERE
	      ml.object_id=ERMS_file_plan.id AND ml.aggregation=2 AND ml.name='permissions'), 0) WHERE refcode<>'lost_found'"); // AGGREGATION_FOLDER=2
else
	$migrations->Log("ERROR! Unknown database type - ".$db->type());

// Set non-zero perm_id for top-level folders
$res = $db->query("SELECT id FROM ERMS_file_plan WHERE perm_id=0 AND parent_id=0");
while (list($folder_id) = $res->fetchRow())
{
	$db->query("INSERT INTO perm_objects (dummy) VALUES (0)");
	$new_perm_id = (int)$db->insertId();

	$db->query("UPDATE ERMS_file_plan SET perm_id=int:pid WHERE id=int:fid", $new_perm_id, $folder_id);
}

// Inherit permissions for all folders that don't have their own permissions for some reason
$iterations = 0;
do {
	$res = $db->query("SELECT id, parent_id FROM ERMS_file_plan WHERE perm_id=0 AND parent_id>0 ORDER BY id");
	if (!$res->hasData())
		break;

	while (list($fid, $parent_id) = $res->fetchRow())
	{
		list($perm_id) = $db->query_row("SELECT perm_id FROM ERMS_file_plan WHERE id=int:pid", $parent_id);
		if ($perm_id)
			$db->query("UPDATE ERMS_file_plan SET perm_id=int:perm_id WHERE id=int:fid", $perm_id, $fid);
	}
	if (++$iterations > 100) // safety trigger
	{
		$migrations->Log("Something is wrong with permissions or folders hierarchy - cannot define all empty perms");
		break;
	}
} while (true);



// Copy perm_id from metadata for all documents
if ($db->type() == 'mssql')
	$db->query("UPDATE ERMS_data SET perm_id=COALESCE(
	    (SELECT me.intval FROM ERMS_metadata_link ml LEFT JOIN ERMS_metadata_element me ON ml.element_id=me.id WHERE
	      ml.object_id=ERMS_data.id AND ml.parent_id IN (ERMS_data.parent_id, 0) AND ml.aggregation=4 AND ml.name='permissions'), 0)"); // AGGREGATION_DATA=4
elseif ($db->type() == 'mysql')
	$db->query("UPDATE ERMS_data SET perm_id=IFNULL(
	    (SELECT me.intval FROM ERMS_metadata_link ml LEFT JOIN ERMS_metadata_element me ON ml.element_id=me.id WHERE
	      ml.object_id=ERMS_data.id AND ml.parent_id IN (ERMS_data.parent_id, 0) AND ml.aggregation=4 AND ml.name='permissions'), 0)"); // AGGREGATION_DATA=4
else
	$migrations->Log("ERROR! Unknown database type - ".$db->type());

// Make sure perm_id is the same for all versions
if ($db->type() == 'mssql')
	$db->query("UPDATE ERMS_data SET perm_id=(SELECT perm_id FROM ERMS_data d WHERE d.id=ERMS_data.primary_version_id)");
elseif ($db->type() == 'mysql')
{
	$db->query("CREATE TEMPORARY TABLE ERMS_perms AS SELECT primary_version_id, perm_id FROM ERMS_data WHERE id=primary_version_id");
	$db->query("CREATE INDEX ERMS_perms_idx ON ERMS_perms (primary_version_id)");
	$db->query("UPDATE ERMS_data SET perm_id=(SELECT perm_id FROM ERMS_perms WHERE ERMS_perms.primary_version_id=ERMS_data.primary_version_id)");
	$db->query("DROP TABLE ERMS_perms");
}
else
	$migrations->Log("ERROR! Unknown database type - ".$db->type());


// Copy perm_id from folder for documents that still have no permissions
if ($db->type() == 'mssql')
	$db->query("UPDATE ERMS_data SET perm_id=COALESCE((SELECT perm_id FROM ERMS_file_plan fp WHERE fp.id=ERMS_data.parent_id), 0) WHERE perm_id=0");
elseif ($db->type() == 'mysql')
	$db->query("UPDATE ERMS_data SET perm_id=IFNULL((SELECT perm_id FROM ERMS_file_plan fp WHERE fp.id=ERMS_data.parent_id), 0) WHERE perm_id=0");
else
	$migrations->Log("ERROR! Unknown database type - ".$db->type());

DB_UPDATE_FILE
);


$migrations->Run('303_docs_create_links.php', <<<'DB_UPDATE_FILE'
<?php
// for all linked documents, create links in their non-primary locations

use \Claromentis\Core\DAL;

/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();


// find all documents linked into more than one folder
$linked_res = $db->query("SELECT data_id, min(folder_id), count(1) cnt FROM ERMS_data_pointer GROUP BY data_id HAVING count(1)>1");

while (list($data_id, $min_folder_id) = $linked_res->fetchRow())
{
	// read the original document
	$r = $db->query("SELECT * FROM ERMS_data WHERE id=int:d_id AND deleted=0", $data_id);
	if (!$r->hasData())
	{
		$migrations->Log("Original document #$data_id (folder #$min_folder_id) not found, link will be lost");
		continue;
	}
	$doc_info = $r->fetchArray();

	// read and process all links except the one with minimal folder id as it's the primary location (as set in earlier migration script)
	$res = $db->query("SELECT * FROM ERMS_data_pointer WHERE data_id=int:d_id AND folder_id<>int:fid", $data_id, $min_folder_id);

	while ($link_info = $res->fetchArray())
	{
		$folder_id = $link_info['folder_id'];
		$data_id = $link_info['data_id'];

		$perm_id_query = new DAL\Query("SELECT me.intval FROM ERMS_metadata_link ml, ERMS_metadata_element me
 					WHERE ml.name='permissions' AND ml.object_id=int:data_id AND ml.parent_id=int:f_id AND me.id=ml.element_id");
		$perm_id_query->Bind('data_id', $data_id);
		$perm_id_query->Bind('f_id', $folder_id);
		$perm_res = $db->query($perm_id_query);
		if ($perm_res->hasData())  // will have no data if document has own permissions
			list($perm_id) = $perm_res->fetchRow();
		else
			$perm_id = 0; // set perm_id to zero in order to inherit from parent folder later

		// Add new document
		$insert_data = array(
			'str:title' => $doc_info['title'],
			'int:date_created' => $doc_info['date_created'],
			'int:date_last_modified' => $doc_info['date_last_modified'],
			'int:date_last_accessed' => $doc_info['date_last_accessed'],
			'int:date_declared' => $doc_info['date_declared'],
			'int:type' => $doc_info['type'],
			'int:creator' => $doc_info['creator'],
			'int:version_num' => 1,
			'int:deleted' => 0,
			'int:doc_type' => 4, //DOC_TYPE_LINK,
			'int:parent_id' => $folder_id,
		    'int:perm_id' => $perm_id,
		);

		$db->query(new DAL\QueryInsert('ERMS_data', $insert_data));
		$new_id = $db->insertId();
		if (!$new_id)
		{
			$migrations->Log("Failed adding new document, skipped ".json_encode($insert_data));
			continue;
		}

		$query_update = new DAL\QueryUpdate('ERMS_data', 'id=int:id', array(
			'int:doc_id' => $new_id,
			'int:primary_version_id' => $new_id,
			'str:refcode' => 'Link_'.$new_id,
		));
		$query_update->Bind('id', $new_id);

		$db->query($query_update);


		// Add new document metadata - pointed to the target doc_id
		$db->query(new DAL\QueryInsert('ERMS_metadata_element', array(
			"str:name" => 'doc_link_target_doc_id',
			"int:intval" => $doc_info['doc_id'],
			"int:type" => 1, // META_TYPE_INT
		)));
		$element_id = $db->insertId();

		if (!$element_id)
		{
			$migrations->Log("Failed creating document metadata element in folder $folder_id ".json_encode($doc_info));
			$db->query("DELETE FROM ERMS_data WHERE id=int:it", $new_id);
			continue;
		}

		$db->query(new DAL\QueryInsert('ERMS_metadata_link', array(
			'int:object_id' => $new_id,
		    'int:aggregation' => 4, // AGGREGATION_DATA
		    'int:element_id' => $element_id,
		    'int:inherited' => 0,
		    'int:parent_id' => 0,
		    'str:name' => 'doc_link_target_doc_id',
		)));
	}
}


// Copy perm_id from folder for documents that have no permissions
if ($db->type() == 'mssql')
	$db->query("UPDATE ERMS_data SET perm_id=COALESCE((SELECT perm_id FROM ERMS_file_plan fp WHERE fp.id=ERMS_data.parent_id), 0)");
elseif ($db->type() == 'mysql')
	$db->query("UPDATE ERMS_data SET perm_id=IFNULL((SELECT perm_id FROM ERMS_file_plan fp WHERE fp.id=ERMS_data.parent_id), 0)");
else
	$migrations->Log("ERROR! Unknown database type - ".$db->type());

DB_UPDATE_FILE
);


$migrations->Run('304_docs_drop_table.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$db->DropIndex('ERMS_data_pointer', 'ERMS_data_pointer_idx1');
$db->DropPrimaryKey('ERMS_data_pointer');
$db->DropTable('ERMS_data_pointer');

$db->query("DELETE FROM ERMS_metadata_link WHERE aggregation IN (2, 4, 6) AND name='permissions'");
$db->query("DELETE FROM ERMS_metadata_element WHERE id NOT IN (SELECT element_id FROM ERMS_metadata_link)");
$db->query("DELETE FROM ERMS_metadata_inherit WHERE aggregation IN (2, 4, 6) AND name='permissions'");

DB_UPDATE_FILE
);


$migrations->Run('401_ic_search_data.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$db->AddColumn('hd_issue', 'search_data', 'CLOB NULL');

DB_UPDATE_FILE
);


$migrations->Run('500_blogs_data.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$db->DropTable('news_options');
$db->DropTable('news_comments');


// blog_post
$table_descr = array(
	'id'	=>	"IDENTITY",
	'user_id'	=>	"INT NOT_NULL DEFAULT 0", // was 'ownerid'
	'link'	=>	"VARCHAR(255) NULL",
	'channel_id'	=>	"INT NOT_NULL DEFAULT 0", // was 'news_channel_id'
	'date_start'	=>	"INT_DATE NULL",
	'date_delete'	=>	"INT_DATE NULL",
	'full_text_type'	=>	"VARCHAR(10) NULL", // was 'news_full_text_type'
	'is_draft'	=>	"BOOL NOT_NULL DEFAULT 0",
	'status'	=>	"INT NOT_NULL DEFAULT 0",
	'comments_mode'	=>	"INT NOT_NULL DEFAULT 0",
	'deleted'	=>	"INT NULL DEFAULT 0",
);

$db->CreateTable('blog_post', $table_descr, true);
$db->CreateIndex('blog_post', 'user_id', 'user_id');
$db->CreateIndex('blog_post', 'date_start', 'date_start');
$db->CreateIndex('blog_post', 'is_draft', 'is_draft');
$db->CreateIndex('blog_post', 'status', 'status');

$query = "INSERT INTO blog_post (id, user_id, link, channel_id, date_start, date_delete, full_text_type, is_draft, status, comments_mode, deleted)
 				SELECT id, ownerid, link, news_channel_id, date_start, date_delete, news_full_text_type, is_draft, status, comments_mode, deleted
 					FROM news WHERE news_channel_id IN (SELECT id FROM news_channel WHERE owner>0)";
if ($db->type() == 'mssql')
	$db->query("SET IDENTITY_INSERT blog_post ON; $query; SET IDENTITY_INSERT blog_post OFF");
else
	$db->query($query);


// blog_translations
$table_descr = array(
	'id'	=>	"IDENTITY",
	'language'	=>	"VARCHAR(5) NULL",
	'blog_post_id'	=>	"INT NOT_NULL DEFAULT 0",
	'title'	=>	"VARCHAR(255) NULL",
	'blog_text'	=>	"VARCHAR_MAX NULL",
	'blog_full_text' =>	"CLOB NULL",
);

$db->CreateTable('blog_translations', $table_descr, true);
$query = "INSERT INTO blog_translations (language, blog_post_id, title, blog_text, blog_full_text) SELECT language, news_id, title, newstext, news_full_text FROM news_translations WHERE news_id IN (SELECT id FROM blog_post)";
$db->query($query);


// blog_channel
$table_descr = array(
	'id'	=>	"IDENTITY",
	'title'	=>	"VARCHAR(255) NULL", // was 'channel_name'
	'owner_id'	=>	"INT NOT_NULL DEFAULT 0", // was 'owner'
);

$db->CreateTable('blog_channel', $table_descr, true);

$query = "INSERT INTO blog_channel (id, title, owner_id) SELECT id, channel_name, owner FROM news_channel WHERE owner>0";
if ($db->type() == 'mssql')
	$db->query("SET IDENTITY_INSERT blog_channel ON; $query; SET IDENTITY_INSERT blog_channel OFF");
else
	$db->query($query);


$blog_class = 99; // PERM_CLASS_BLOG_CHANNEL
$news_class = 52; // PERM_CLASS_NEWS_CHANNEL
$db->query("UPDATE permissions SET class_id=int:blog_class WHERE class_id=int:news_class AND object_id IN (SELECT id FROM blog_channel)", $blog_class, $news_class);


// blog_subscriptions
$table_descr = array(
	'user_id'	=>	"INT NOT_NULL DEFAULT 0",
	'channel_id'	=>	"INT NOT_NULL DEFAULT 0",
);

$db->CreateTable('blog_subscriptions', $table_descr, true);
$db->CreatePrimaryKey('blog_subscriptions', 'user_id', 'channel_id');
$db->CreateIndex('blog_subscriptions', 'user_id', 'user_id');
$db->CreateIndex('blog_subscriptions', 'channel_id', 'channel_id');

$query = "INSERT INTO blog_subscriptions SELECT user_id, news_channel_id FROM news_channel_users WHERE news_channel_id IN (SELECT id FROM blog_channel)";
$db->query($query);



DB_UPDATE_FILE
);


$migrations->Run('501_blogs_change_aggregation.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$aggr_blog = 120; // AGGREGATION_BLOG
$aggr_news = 21;  // AGGREGATION_NEWS
$db->query("UPDATE comments SET aggregation=int:blog WHERE aggregation=int:news AND object_id IN (SELECT id FROM blog_post)",
           $aggr_blog, $aggr_news);

$db->query("UPDATE trash_can SET aggregation=int:blog WHERE aggregation=int:news AND obj_id IN (SELECT id FROM blog_post)",
           $aggr_blog, $aggr_news);

$db->query("DELETE FROM metadata_simple WHERE aggregation IN (int:blog, int:news) AND object_id IN (SELECT id FROM blog_post)",
           $aggr_blog, $aggr_news);


DB_UPDATE_FILE
);


$migrations->Run('502_blogs_merge_translations.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$db->AddColumn('blog_post', 'title', 'VARCHAR(255) NULL');
$db->AddColumn('blog_post', 'summary', 'VARCHAR_MAX NULL');
$db->AddColumn('blog_post', 'full_text', 'CLOB NULL');

$res = $db->query("SELECT id FROM blog_post");
while (list($blog_id) = $res->fetchRow())
{
	$title = $summary = $full_text = '';

	$res2 = $db->query("SELECT * FROM blog_translations WHERE blog_post_id=int:id", $blog_id);
	while ($arr = $res2->fetchArray())
	{
		$title .= $arr['title'].' ';
		$summary .= $arr['blog_text'].' ';
		$full_text .= $arr['blog_full_text'].' ';
	}

	$q = new \Claromentis\Core\DAL\QueryUpdate('blog_post', 'id=int:id', array(
			'str:title' => trim($title),
			'str:summary' => trim($summary),
			'clob:full_text' => trim($full_text),
		));
	$q->Bind('id', $blog_id);
	$db->query($q);
}

$db->DropTable('blog_translations');

DB_UPDATE_FILE
);


$migrations->Run('503_blog_news_cleanup.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$db->query("DELETE FROM news WHERE id IN (SELECT id FROM blog_post)");
$db->query("DELETE FROM news_translations WHERE news_id NOT IN (SELECT id FROM news)");
$db->query("DELETE FROM news_channel WHERE id IN (SELECT id FROM blog_channel)");
$db->query("DELETE FROM news_channel_users WHERE news_channel_id NOT IN (SELECT id FROM news_channel)");


DB_UPDATE_FILE
);


$migrations->Run('504_blog_cover_images.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$cdn = \Claromentis\Core\Services::I()->GetCDN();
try
{
	$cdn->CreateDir("blog/images");
} catch (Exception $e)
{
	$migrations->Log("Couldn't create blog/ directory in CDN: ".$e->getMessage());
}

$res = $db->query("SELECT id FROM blog_post");
while (list($blog_id) = $res->fetchRow())
{
	try
	{
		if ($cdn->Exists("news/{$blog_id}.jpg"))
			$cdn->RenameFile("news/{$blog_id}.jpg", "blog/{$blog_id}.jpg");
	} catch (Exception $e)
	{
		$migrations->Log("Couldn't move blog image from news/{$blog_id}.jpg to blog/{$blog_id}.jpg: ".$e->getMessage());
	}
	try
	{
		if ($cdn->Exists("news/{$blog_id}_full.jpg"))
			$cdn->RenameFile("news/{$blog_id}_full.jpg", "blog/{$blog_id}_full.jpg");
	} catch (Exception $e)
	{
		$migrations->Log("Couldn't move blog image from news/{$blog_id}_full.jpg to blog/{$blog_id}_full.jpg: ".$e->getMessage());
	}
}

try
{
	$cdn->CreateDir("blog/images");
} catch (Exception $e)
{
	$migrations->Log("Couldn't create blog/images/ directory in CDN: ".$e->getMessage());
}

DB_UPDATE_FILE
);


$migrations->Run('505_blog_admin_panel.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations \Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$apc = $migrations->GetAdminPanelCreator();
$apc->Create('blog', '../blog/admin.php', array('name' => 'Blog', 'css_class' => 'icon-edit'));

DB_UPDATE_FILE
);


$migrations->Run('601_ic_issue_import_log.php', <<<'DB_UPDATE_FILE'
<?php

$db = $migrations->GetDb();

// New table for InfoCapture issue importing. This is used to hold the status of an import for the frontends real-time log (via regular AJAX calls)
$table_descr = array(
	'id'				=> "IDENTITY",
	'project_id'		=> "INT NOT_NULL DEFAULT 0",
	'import_key'		=> "INT NOT_NULL DEFAULT 0",
	'content' 			=> "VARCHAR_MAX NULL",
	'import_sequence'	=> "INT NOT_NULL DEFAULT 0"
);
$db->CreateTable('hd_issue_import_log', $table_descr, true);
DB_UPDATE_FILE
);


$migrations->Run('602_ic_checkbox_list.php', <<<'DB_UPDATE_FILE'
<?php

$db = $migrations->GetDb();

// Field for fields - 'inline_layout'. Used by checkbox list and radio to switch between horizontal and vertical list layout
$db->AddColumn('fb_field', 'inline_layout', 'INT NOT_NULL DEFAULT 0');

DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('25.01');
