define(['cla_angular', './icon_grid.html', './icon_grid.scss'], function (angular, template) {
	var moduleName = 'cla.core.icon_grid';
	var module;
	try {
		module = angular.module(moduleName);
	} catch(err) {
		// named module does not exist, so create one
		module = angular.module(moduleName, []);
	}

	module.directive('claIconGrid', claIconGrid);

	claIconGrid.$inject = ['$timeout'];
	function claIconGrid($timeout) {
		var linkDeps = {$timeout: $timeout};

		return {
			restrict: 'E',
			require: '^ngModel',
			templateUrl: template,
			scope: {
				ngModel: '=',
				id: '@'
			},
			controllerAs: 'icons',
			controller: controller,
			bindToController: true
		};
	}

	function controller()
	{
		var ctrl = this;

        this.$onInit = function() {
            ctrl.raw_options = {
                // frequently used
                "file": "file",
                "picture": "picture",
                "notes": "notes",
                "book": "book",
                "folder-closed": "folder-closed",
                "calendar": "calendar",
                "envelope": "envelope",
                "book-open": "book-open",
                "home": "home",
                "building": "building",
                "parents": "parents",
                "star": "star",
                "link": "link",
                "global": "global",
                "education": "education",
                // webapps and social
                "cloud-app":"cloud-app",
                "google-plus":"google-plus",
                "facebook":"facebook",
                "twitter":"twitter",
                "instagram":"instagram",
                "snapchat":"snapchat",
                "blog-rss":"blog-rss",
                "windows":"windows",
                "sharepoint":"sharepoint",
                "apple":"apple",
                "dropbox":"dropbox",
                "box":"box",
                "onedrive":"onedrive",
                "slack":"slack",
                "youtube":"youtube",
                "skype":"skype",
                "linkedin":"linkedin",
                "trello":"trello",
                "eventbrite":"eventbrite",
                "android":"android",
                "map":"map",
                //claromentis apps
                "blog":"blog",
                "conversation": "conversation",
                "digital-asset": "digital-asset",
                "important-day": "important-day",
                "coins": "coins",
                "money": "money",
                "chat": "chat",
                "comments": "comments",
                "plane": "plane",
                "list": "list",
                "newspaper": "newspaper",
                "pages": "pages",
                "address-book": "address-book",
                "log-book": "log-book",
                "project": "lproject",
                "charts": "charts",
                "room-booking": "room-booking",
                "search": "search",
                "user-structure": "user-structure",
                "meeting": "meeting",
                "palette": "palette",
                "info-sign": "info-sign",
                // others
                "imac":"imac",
                "show-big-thumbnails": "show-big-thumbnails",
                "show-thumbnails": "show-thumbnails",
                "cogwheel":"cogwheel",
                "certificate":"certificate",
                "podium":"podium",
                "cup":"cup",
                "share-alt": "share-alt",
                "stats": "stats",
                "pie-chart": "pie-chart",
                "group": "group",
                "keys": "keys",
                "rocket":"rocket",
                "exclamation-sign":"exclamation-sign",
                "glass": "glass",
                "leaf": "leaf",
                "dog": "dog",
                "user": "user",
                "girl": "girl",
                "car": "car",
                "film": "film",
                "bin":"bin",
                "camera": "camera",
                "heart": "heart",
                "beach-umbrella": "beach-umbrella",
                "train": "train",
                "music": "music",
                "snowflake": "snowflake",
                "fire": "fire",
                "road": "road",
                "cars": "cars",
                "notes-2": "notes-2",
                "pencil": "pencil",
                "bus": "bus",
                "luggage": "luggage",
                "clock": "clock",
                "projector": "projector",
                "history": "history",
                "cargo": "cargo",
                "keynote": "keynote",
                "paperclip": "paperclip",
                "lightbulb": "lightbulb",
                "tag": "tag",
                "tags": "tags",
                "cleaning": "cleaning",
                "gift": "gift",
                "umbrella": "umbrella",
                "cup": "cup",
                "stroller": "stroller",
                "log-book": "log-book",
                "table": "table",
                "message-full": "message-full",
                "inbox": "inbox",
                "edit": "edit",
                "show-big-thumbnails": "show-big-thumbnails",
                "screenshot": "screenshot",
                "shopping-cart": "shopping-cart",
                "moon": "moon",
                "sun": "sun",
                "cloud": "cloud",
                "pen": "pen",
                "anchor": "anchor",
                "qrcode": "qrcode",
                "bank": "bank",
                "keyboard-wireless": "keyboard-wireless",
                "cutlery": "cutlery",
                "settings": "settings",
                "scissors": "scissors",
                "bicycle": "bicycle",
                "sort": "sort",
                "tie": "tie",
                "wallet": "wallet",
                "playing-dices": "playing-dices",
                "turtle": "turtle",
                "rabbit": "rabbit",
                "nameplate": "nameplate",
                "shopping-bag": "shopping-bag",
                "bullhorn": "bullhorn",
                "crown": "crown",
                "globe-af": "globe-af",
                "phone-alt": "phone-alt",
                "blacksmith": "blacksmith",
                "headset": "headset"
            };

            //reorganize array to have keys available
            ctrl.options = Object.keys(ctrl.raw_options).map(function(key)
            {
                return {
                    key: key,
                    value: ctrl.raw_options[key]
                };
            });

            if (ctrl.ngModel === '')
                ctrl.ngModel = ctrl.options[0].key;
        };
	}


});
