define(['cla_angular', './icon_picker.html', './icon_picker.css'], function (angular, template) {
	var moduleName = 'cla.core.icon_picker';
	var module;
	try {
		module = angular.module(moduleName);
	} catch(err) {
		// named module does not exist, so create one
		module = angular.module(moduleName, []);
	}

	module.directive('claIconPicker', iconPicker);

	iconPicker.$inject = ['$timeout'];
	function iconPicker($timeout) {
		var linkDeps = {$timeout: $timeout};

		return {
			restrict: 'E',
			require: '^ngModel',
			templateUrl: template,
			scope: {
				ngModel: '=',
				id: '@'
			},
			controllerAs: 'icons',
			controller: controller,
			link: angular.bind(linkDeps, link)
		};
	}

	controller.$inject = ['$scope'];
	function controller($scope)
	{
		var ctrl = this;

        this.$onInit = function() {
            ctrl.id = $scope.id;

            ctrl.raw_options = {
                "exclamation-sign":"exclamation-sign",
                "glass": "glass",
                "leaf": "leaf",
                "dog": "dog",
                "user": "user",
                "girl": "girl",
                "car": "car",
                "film": "film",
                "envelope": "envelope",
                "camera": "camera",
                "heart": "heart",
                "beach-umbrella": "beach-umbrella",
                "train": "train",
                "music": "music",
                "home": "home",
                "snowflake": "snowflake",
                "fire": "fire",
                "parents": "parents",
                "road": "road",
                "cars": "cars",
                "notes-2": "notes-2",
                "pencil": "pencil",
                "bus": "bus",
                "luggage": "luggage",
                "file": "file",
                "coins": "coins",
                "plane": "plane",
                "notes": "notes",
                "stats": "stats",
                "charts": "charts",
                "pie-chart": "pie-chart",
                "group": "group",
                "keys": "keys",
                "calendar": "calendar",
                "star": "star",
                "link": "link",
                "clock": "clock",
                "projector": "projector",
                "history": "history",
                "cargo": "cargo",
                "keynote": "keynote",
                "paperclip": "paperclip",
                "lightbulb": "lightbulb",
                "tag": "tag",
                "tags": "tags",
                "cleaning": "cleaning",
                "gift": "gift",
                "umbrella": "umbrella",
                "book": "book",
                "cup": "cup",
                "stroller": "stroller",
                "log-book": "log-book",
                "address-book": "address-book",
                "building": "building",
                "table": "table",
                "message-full": "message-full",
                "inbox": "inbox",
                "picture": "picture",
                "folder-open": "folder-open",
                "edit": "edit",
                "show-big-thumbnails": "show-big-thumbnails",
                "screenshot": "screenshot",
                "shopping-cart": "shopping-cart",
                "moon": "moon",
                "sun": "sun",
                "cloud": "cloud",
                "pen": "pen",
                "anchor": "anchor",
                "conversation": "conversation",
                "qrcode": "qrcode",
                "bank": "bank",
                "keyboard-wireless": "keyboard-wireless",
                "cutlery": "cutlery",
                "settings": "settings",
                "scissors": "scissors",
                "bicycle": "bicycle",
                "sort": "sort",
                "tie": "tie",
                "wallet": "wallet",
                "playing-dices": "playing-dices",
                "turtle": "turtle",
                "rabbit": "rabbit",
                "nameplate": "nameplate",
                "shopping-bag": "shopping-bag",
                "bullhorn": "bullhorn",
                "crown": "crown",
                "globe-af": "globe-af",
                "global": "global",
                "phone-alt": "phone-alt",
                "blacksmith": "blacksmith",
                "headset": "headset"
            };
            ctrl.options = Object.keys(ctrl.raw_options).map(function(key)
            {
                return {
                    key: key,
                    value: ctrl.raw_options[key]
                };
            });

            if ($scope.ngModel === '')
                $scope.ngModel = ctrl.options[0].key;
        };
	}

	function link(scope, iElement, iAttrs, ctrl)
	{
		this.$timeout(function()
		{
			angular.element(iElement).find('#' + iAttrs.id + '-inner').select2({placeholder: iAttrs.placeholder, templateResult: iconPickerTemplate, templateSelection: iconPickerTemplate});
		});
	}

	function iconPickerTemplate(icon)
	{
		if (!icon.id)
			return icon.text;

		return $('<span class="icon-picker-row"><span style="" class="glyphicons glyphicons-' + icon.text + ' icon-picker-row icon-picker-icon"></span> ' + icon.text + '</span>');
	}
});
