var angular = require('cla_angular');

/**
 * The controller that handles the main report page
 *
 *
 */
(function () {
	'use strict';

	var moduleName = 'cla.core.datatable'; var module;
	try { module = angular.module(moduleName); }
	catch(err) { module = angular.module(moduleName, []); }

	module.controller('DataTableController', DataTableController);
	DataTableController.$inject = ['dtService', '$timeout'];

	/**
	 *
	 * @param dtService
	 * @param $timeout
	 * @constructor
	 */
	function DataTableController(dtService, $timeout) {
		var controller = this;

		controller.init = init;
		//////////////////

		/**
		 * initialise, wait for digest to finish then run the build
		 */
		function init(name, initial_params) {
			$timeout(function () {
				var service = dtService.get(name);

				service.initial = initial_params;
				service.build();
			}, 0);
		}
	}
}());
