define(['jquery',
        './dynamic_field_changes/field.js', './dynamic_field_changes/fields.js',
        './dynamic_field_changes/rule.js', './dynamic_field_changes/rules.js',
        './dynamic_field_changes/trigger.js', './dynamic_field_changes/triggers.js',
        './dynamic_field_changes/undo.js', './utilities.js'],
function (jQuery, Field, Fields, Rule, Rules, Trigger, Triggers, Undo) {
    "use strict";

    /** @namespace */
    var ICDynamicFieldChanges = window.ICDynamicFieldChanges || {};

    /** @namespace */
    var Instance = window.Instance || {};
    window.Instance = Instance;

    ICDynamicFieldChanges.init = function() {
        Instance.Undo = new ICDynamicFieldChanges.Undo();
        Instance.Fields = new ICDynamicFieldChanges.Fields();
        Instance.Triggers = new ICDynamicFieldChanges.Triggers();
        Instance.Fields.view.render();
        Instance.Triggers.view.render();
        window.onbeforeunload = function() {
            if (Instance.Undo.model.history.length > 0) {
                return 'You have ' + Instance.Undo.model.history.length + ' unsaved changes.';
            }
        };
    };

    ICDynamicFieldChanges.Undo = Undo;
    ICDynamicFieldChanges.Fields = Fields;
    ICDynamicFieldChanges.Triggers = Triggers;

    return ICDynamicFieldChanges;
});
