define(['jquery',
            './field_rights/field.js', './field_rights/fields.js',
            './field_rights/group.js', './field_rights/groups.js',
            './field_rights/right.js', './field_rights/rights.js',
            './field_rights/role.js', './field_rights/roles.js',
            './field_rights/rule.js', './field_rights/rules.js',
            './field_rights/undo.js', './utilities.js'],
function (jQuery, Field, Fields, Group, Groups, Right, Rights, Role, Roles, Rule, Rules, Undo) {

    /** @namespace */
    var ICFieldRights = window.ICFieldRights || {};

    /** @namespace */
    var Instance = window.Instance || {};
    window.Instance = Instance;

    ICFieldRights.init = function () {
        'use strict';
        Instance.Undo = new Undo();
        Instance.Roles = new Roles();
        Instance.Roles.collection.setData(window.roles);
        Instance.Rules = new Rules();
        Instance.Rules.collection.setData(window.rules);
        Instance.Groups = new Groups();
        Instance.Groups.collection.setData(window.groups);
        Instance.Groups.view.render();
        window.onbeforeunload = function () {
            if (Instance.Undo.model.history.length > 0) {
                return lmsg('infocapture.admin.general.unsaved_changes', Instance.Undo.model.history.length);
            }
        };
    };

    ICFieldRights.Field = Field;
    ICFieldRights.Fields = Fields;
    ICFieldRights.Group = Group;
    ICFieldRights.Groups = Groups;
    ICFieldRights.Right = Right;
    ICFieldRights.Rights = Rights;
    ICFieldRights.Rule = Rule;
    ICFieldRights.Rules = Rules;
    ICFieldRights.Role = Role;
    ICFieldRights.Roles = Roles;
    ICFieldRights.Undo = Undo;

    return ICFieldRights;
});
