define([], function () {

    /**
     * Role model
     * @class
     * @constructor
     * @property {Number} id
     */
    var Role = function () {
        'use strict';
        this.model = new Role.Model();
        this.view = new Role.View();
        this.model.setView(this.view);
        this.view.setModel(this.model);
    };
    Role.Model = function () {
        'use strict';
        this.view = null;
        /**
         * Role id
         * @private
         * @type {Number}
         */
        this.id = null;

        /**
         * Role position
         * @private
         * @type {Number}
         */
        this.pos = null;

        /**
         * Role name
         * @private
         * @type {String}
         */
        this.name = null;

        /**
         * Role bitmask
         * @private
         * @type {Number}
         */
        this.bitmask = null;
    };

    Role.Model.prototype = (function () {
        'use strict';
        var setView = function (view) {
            this.view = view;
        };
        /**
         * Set object data
         * @private
         * @memberOf Role
         * @param {Object} data
         */
        var setData = function (data) {
            setId.call(this, data.id);
            setPosition.call(this, data.pos);
            setName.call(this, data.name);
            setBitmask.call(this, data.bitmask);
        };

        var setId = function (id) {
            this.id = parseInt(id, 10);
        };

        /**
         * Get the role id
         * @private
         * @memberOf Role
         * @returns {Number}
         */
        var getId = function () {
            if (_.isNumber(this.id)) {
                return parseInt(this.id, 10);
            } else {
                return NaN;
            }
        };

        var setPosition = function (position) {
            this.position = parseInt(position, 10);
        };

        /**
         * Get the role position
         * @private
         * @memberOf Role
         * @returns {Number}
         */
        var getPosition = function () {
            if (_.isNumber(this.pos)) {
                return parseInt(this.pos, 10);
            } else {
                return NaN;
            }
        };

        var setName = function (name) {
            this.name = name;
        };

        /**
         * Get the role name
         * @private
         * @memberOf Role
         * @returns {String}
         */
        var getName = function () {
            if (_.isString(this.name)) {
                return this.name;
            } else {
                return '';
            }
        };

        var setBitmask = function (bitmask) {
            this.bitmask = parseInt(bitmask, 10);
        };

        /**
         * Get role bitmask
         * @private
         * @memberOf Role
         * @returns {Number}
         */
        var getBitmask = function () {
            if (_.isNumber(this.bitmask)) {
                return parseInt(this.bitmask, 10);
            } else {
                return NaN;
            }
        };

        return {
            setView: setView,
            /**
             * Initalise object
             * @public
             * @memberOf Role
             */
            setData: setData,

            /**
             * Get role id
             * @public
             * @memberOf Role
             * @returns {Number}
             */
            id: getId,

            /**
             * Get role position
             * @public
             * @memberOf Role
             * @returns {Number}
             */
            pos: getPosition,

            /**
             * Get role name
             * @public
             * @memberOf Role
             * @returns {Sting}
             */
            name: getName,

            /**
             * Get role bitmask
             * @public
             * @memberOf Role
             * @returns {Number}
             */
            bitmask: getBitmask
        };
    })();

    Role.View = function () {
        'use strict';
        this.model = null;
    };

    Role.View.prototype = (function () {
        'use strict';

        var setModel = function (model) {
            this.model = model;
        };

        /**
         * Set DOM element
         * @private
         * @memberOf ICFieldRights.Fields.View
         * @param {Object} el - jQuery DOM element from ICFieldRights.Group.View
         */
        var setElement = function (el) {
            this.el = el;
        };

        /**
         * Get DOM element
         * @private
         * @memberOf ICFieldRights.Fields.View
         * @returns {Object}
         */
        var getElement = function () {
            return this.el;
        };

        var renderColGroup = function () {
            this.el.find('.role-col-group').append(_.template('<col width="90" /> <col width="90" />')({}));
        };

        var renderHeader = function () {
            this.el.find('.role-header th:last-child').before(_.template('<th colspan="2" class="text-center" data-bitmask="{{- bitmask }}">{{- name }}</th>')(this.model));
        };

        var renderSubHeader = function () {
            this.el.find('.role-subheader th:last-child').before(_.template('<th class="text-center">' + lmsg('infocapture.admin.field_rights.right_view') + '</th>')({}));
            this.el.find('.role-subheader th:last-child').before(_.template('<th class="text-center">' + lmsg('infocapture.admin.field_rights.right_edit') + '</th>')({}));
        };

        var render = function (el) {
            setElement.call(this, el);
            renderColGroup.call(this);
            renderHeader.call(this);
            renderSubHeader.call(this);
        };
        return {
            setModel: setModel,

            render: render
        };
    })();

    return Role;
});
