/**
 * Holds data on ldap attributes
 *
 */
(function () {
	'use strict';

	angular.module('cla.ldap.connections')
		.service('attributesService', attributesService);

	attributesService.$inject = ['connectionService', 'directoryService', 'ldapResources'];

	/**
	 * @param connectionService
	 * @param directoryService
	 * @param ldapResources
	 */
	function attributesService(connectionService, directoryService, ldapResources) {
		var service = {
			properties: {
				exampleUserDN: '',
				mappings: { },
				useImportPhoto: false,
				usePopulateOrgChart: false,
				importPhotoAttr: null,
				populateOrgChartAttr: null,
				populateExtranetAttr: null,
				dateFormat: '',
                dateNoYearFormat: ''
			},

			fetch: fetch,
			mapNames: mapNames,
			mapFieldNames: mapFieldNames,
			preload: preload
		};

		return service;

		/**
		 * fetch attributes for an example user
		 */
		function fetch() {
			var connectionObject = connectionService.mapNames();
			var directoryObject = directoryService.mapNames();
			var attributesObject = service.mapNames();

			return ldapResources.fetchAttributes(
				connectionObject,
				directoryObject,
				attributesObject
			).$promise;
		}

		/**
		 * map js names to expected url params
		 */
		function mapNames() {
			return {
				'user_dn': service.properties.exampleUserDN
			};
		}

		/**
		 * map js field names to expected url params
		 */
		function mapFieldNames() {
			var object = {
				'fields_map': service.properties.mappings
			};

			object.map_profile_photo = service.properties.useImportPhoto
				? service.properties.importPhotoAttr : null;

			object.map_cla_orgchart = service.properties.usePopulateOrgChart
				? service.properties.populateOrgChartAttr : null;

			object.map_cla_extranet = service.properties.usePopulateExtranet
				? service.properties.populateExtranetAttr : null;

			object.date_format = service.properties.dateFormat;
            object.date_no_year_format = service.properties.dateNoYearFormat;

			return object;
		}

		/**
		 * preloads the object with the data passed to this function
		 */
		function preload(data, date_formats, date_no_year_formats) {
		  var object = {};
			if (data) {
				object.mappings = Array.isArray(data.fields_map) ? {} : data.fields_map;

				if (data.map_profile_photo) {
					object.useImportPhoto = true;
					object.importPhotoAttr = data.map_profile_photo;
				}

				if (data.map_cla_orgchart) {
					object.usePopulateOrgChart = true;
					object.populateOrgChartAttr = data.map_cla_orgchart;
				}

				if (data.map_cla_extranet) {
					object.usePopulateExtranet = true;
					object.populateExtranetAttr = data.map_cla_extranet;
				}

                if (data.date_format) {
                      object.dateFormat = data.date_format;
                    } else {
                      object.dateFormat = '';
                }

                if (data.date_no_year_format) {
                    object.dateNoYearFormat = data.date_no_year_format;
                } else {
                    object.dateNoYearFormat = '';
                }
            }

            object.dateOptions = date_formats;
            object.dateNoYearOptions = date_no_year_formats;
            angular.extend(service.properties, object);
		}
	}
}());
