/**
 * LDAP form helper popovers
 */
(function () {
	'use strict';

	angular.module('cla.ldap.connections')
		.directive('ldapHelper', helper);

	/**
	 *
	 */
	function helper () {
		return {
			link: link,
			restrict: 'E',
			scope: {
				msg: '@'
			},
			template: '<a class="h-100 d-block" href="#"><ion-icon class="mt-2" name="information-circle-outline"></ion-icon></a>'
		};

		function link (scope, element) {
			var msg = lmsg(scope.msg);
			element.click(function(e) {
				e.preventDefault();
			}).popover({
				html: true,
				content: '<a class="btn-popover-close float-right" href="#">&times;</a>' + msg,
				container: 'body',
				placement: 'auto'
			});

			$(document).on("click", ".popover .btn-popover-close" , function(e){
				e.preventDefault();
				$(this).parents(".popover").popover('hide');
			});

			$(element).on("show.bs.popover", function(e){
				$($(element).data("bs.popover").tip).css({"max-width": "500px", "min-width": "200px", "font-size" : "12px"});
			});
		}
	}
}());
