/**
 * User Groups form section
 */
(function () {
	'use strict';

	angular.module('cla.ldap.connections')
		.directive('userGroups', userGroups);

	userGroups.$inject = ['userGroupsService'];

	/**
	 * @param userGroupsService service
	 */
	function userGroups (service) {
		return {
			controller: controller,
			controllerAs: 'ug',
			restrict: 'E',
			scope: { },
			templateUrl: '/interface_default/admin/system/templates/user_groups.directive.html'
		};

		function controller () {
			var ug = this;
			this.properties = service.properties;

			// form variables
			this.completed = false;
			this.helperText = lmsg('admin.ldap.text.user_group_helper');

			// function variables
			this.next = next;

			init();

			function init() {
				service.preload(ldap_preload.form_data);
				if (ldap_preload.form_data && ldap_preload.form_data.id) {
					ug.completed = true;
				}
			}

			/**
			 * progress to the next section
			 */
			function next() {
				this.completed = true;
				$('#collapse-user-groups').collapse('hide');
				$('#collapse-status').collapse('show');
			}
		}
	}
}());