@javascript @core @calendar
Feature: Verify calendar event creation.

  Background:
	Given I am on a Claromentis site
	And the following people exist:
	  | username   | password | surname    | firstname | email                  |
	  | user1      | password | User1      | Bob1      | user1@example.com      |
	  | user2      | password | User2      | Bob2      | user2@example.com      |
	  | user3      | password | User3      | Bob3      | user3@example.com      |

  Scenario: Create a single calendar event and invite a couple of users.

	Given I login as user "user1" with password "password"
	When I open the calendar
	And I click element with ".fc-today"
	And I follow "More options"
	Then I should see "Add/Edit event"

	When I fill in "Name" with "Meeting 1"
	And I fill in "Description" with "This is a description of Meeting 1"
	And I press "Add user"
	Then I should see "Pick user"

	When I check element "#pu_keyword_0" exists
	And I fill in "Keyword" with "User"
	Then I wait to see "Bob2 User2"

	When I select "Bob2 User2" from "pu_select_0"
	And I additionally select "Bob3 User3" from "pu_select_0"
	And I press "Add selected"
	And I press "Submit"
	Then I wait to see "Event saved successfully"
	And I wait to see "Meeting 1"
	And I check email "Calendar Event Invitation/ Meeting 1" is received by "user1@example.com"
	And I check email "Calendar Event Invitation/ Meeting 1" is received by "user2@example.com"
	And I check email "Calendar Event Invitation/ Meeting 1" is received by "user3@example.com" with content:
    """
Meeting 1
This is a description of Meeting 1
    """

