(function()
{
	var moduleName = 'commentsModule';
	try {
		module = angular.module(moduleName);
	} catch(err) {
		// named module does not exist, so create one
		module = angular.module(moduleName, ['cla.core.lmsg']);
	}

	var shortlinkFilter = function (commentWidthService)
	{
		return function(link)
		{
			if (link === null)
				return null;

			var width = commentWidthService.getWidth() / 10;
			if (link.length > width)
				link = link.slice(0, width - 11) + '...' + link.slice(-8);

			return link;
		}
	};
	shortlinkFilter.$inject = ['commentWidthService'];

	angular.module(moduleName)
	.filter("shortlink", shortlinkFilter)
	.directive('claComments', function()
	{
		var controller = function()
		{
			var ctrl = this;
		};

		return {
			restrict: 'E',
			replace: true,
			controllerAs: 'comments',
			bindToController: true,
			templateUrl: '/intranet/comments/html/ui/comments_directive_template.html',
			scope:
			{
				aggregation: '=',
				objectid: '=',
				newOnTop: '='
			},
			controller: controller
		};
	});
}());