(function()
{
	var moduleName = 'annotations';

	angular.module(moduleName, [])
	.service('annotationService', ['$http', '$timeout', '$document', annotationService]);

	function annotationService($http, $timeout, $document)
	{
		var service = this;
		var names = [];
		var selectedUser = 0;
		var selectedPosition = 0;

        service.getNames = function (names, success, failure) {
            var names_str = 'names[]=' + names.join('&names[]=');
            var promise = $http.get('/api/comments/users/lookup?' + names_str)
                .then(function (response) {
                    service.names = response.data.results;
                    service.selectedPosition = 0;
                    service.selectedUser = 0;
                    if (service.names.length > 0)
                        service.selectedUser = service.names[service.selectedPosition].user_id;
                    success(response.data.results);
                }, function (response) {
                    service.names = [];
                    service.selectedUser = 0;
                    service.selectedPosition = 0;
                    failure(response.data);
                });
        };

		service.selectAnotherUser = function(offset)
		{
			service.selectedPosition += offset;
			if (service.selectedPosition >= service.names.length)
				service.selectedPosition = service.names.length - 1;

			if (service.selectedPosition < 0)
				service.selectedPosition = 0;

			service.selectedUser = 0;
			if (service.names.length > 0)
				service.selectedUser = service.names[service.selectedPosition].user_id;

			return service.selectedUser;
		};

		service.selectUserById = function(user_id)
		{
			for (var i = 0; i < service.names.length; i++)
			{
				if (service.names[i].user_id == user_id)
					service.selectedPosition = i;
			}

			service.selectedUser = user_id;

			return service.selectedUser;
		};

		service.getAnnotationPicker = function()
		{
			var picker = angular.element('#annotationPicker');

			// Does it already exist
			if (picker.length > 0)
				return picker;

			// Create it
			picker = angular.element('<cla-annotation-picker id="annotationPicker" style="display: none;"></cla-annotation-picker>');
			angular.element('body').append(picker);
			angular.bootstrap(picker[0], ['annotations']);

			return picker;
		};

		service.open = function(type, target, callback)
		{
			var picker = service.getAnnotationPicker();
			picker.trigger('annotation-picker-open', [type, target]);

			picker.on('annotation-picker-closed', function($event, text, user_id)
			{
				picker.off('annotation-picker-closed');
				callback(text, user_id);
			});
		};
	}
}());
