/**
 * Single document or folder to show in documents list. DocsListViewBase and other views use it.
 * Though it can be loaded from server, usually it's never loaded directly, but only as a part of various lists
 */
var DocElementModel = Backbone.Model.extend({
	urlRootFile: '/intranet/rest/documents/document/',
	urlRootFolder: '/intranet/rest/documents/folder/',

	defaults: {
		"type": "",
		"title": "no title"
	},
	is_loaded: false,


	initialize: function ()
	{
		bookmarks.bind('add', this.checkBookmarked, this);
		bookmarks.bind('remove', this.checkBookmarked, this);
		bookmarks.bind('reset', this.checkBookmarked, this);
		if (!this.has('is_bookmarked'))
			this.checkBookmarked();
		if (this.get('type') == '' && (this.has('doc_id') || this.has('id')))
		{
			if (this.has('doc_id'))
				this.set({'type' : 'document'}, {silent: true});
			else
				this.set({'type' : 'folder'}, {silent: true});
			this.is_loaded = true;
		}
	},

	parse: function (server_resp)
	{
		if (server_resp['type'] == undefined)
		{
			if (server_resp['doc_id'] != undefined)
				server_resp['type'] = 'document';
			else
				server_resp['type'] = 'folder';
		}
		this.is_loaded = true;
		return server_resp;
	},

	checkBookmarked: function ()
	{
		if (bookmarks.isBookmarked(this.get('type'), this.getObjId()))
		{
			this.set({'is_bookmarked': true});
		} else
		{
			this.set({'is_bookmarked': false});
		}
	},

	matchKeywords: function (keywords)
	{
		if (this.get('title').toLowerCase().indexOf(keywords.toLowerCase()) >= 0)
			return true;

		// Would be nice to have this, but it's incompatible with the server-side filtering
		//if (this.has('description') && this.get('description').toLowerCase().indexOf(keywords.toLowerCase()) >= 0)
		//	return true;
		return false;
	},

	getObjId: function ()
	{
		return this.get('type') == 'document' ? this.get('doc_id') : this.get('id');
	},

	url: function ()
	{
		var url = '';

		if (this.attributes.type == 'document')
			url = this.urlRootFile + this.attributes.doc_id;
		else
			url = this.urlRootFolder + this.attributes.id;

		return url;
	}

/*	,

	isLoaded: function ()
	{
		if (this.get('type') != "")
			return true;
	}*/
});

