/**
 * View for the main documents list. Internally creates and uses DocsCollection that depends on DocsListStateModel
 *  which is assigned by setModel method
 */
var DocsListViewMain = DocsListViewBase.extend({
	el: $('#documentList'),
	docs_list_state: null,
	pagesize: 20,
	statusMessage: lmsg('documents.docs_list_view_main.documents_list'),

	events: {
		'click .js-show-more-btn': "loadNext",
		'loadNextIsInView .js-show-more-btn' : 'loadNext',
		'showMenu': "onShowMenu"
	},

	setVisible: function (visible)
	{
		DocsListViewBase.prototype.setVisible.call(this, visible);
		if (visible)
		{
			if (this.collection.folder_id != this.docs_list_state.get('folder_id'))
			{
				this.load();
				this.renderLoading();
			} else
			{
				this.render();
			}
		}
	},

	render: function ()
	{
		DocsListViewBase.prototype.render.call(this);
		this.showLoaderNode();

		// note, "parent" link it updated in BreadcrumbView class (even though this may sound wrong)

		return this;
	},

	toTemplateData: function (doc)
	{
		var data = doc.toJSON();
		data.obj_id = doc.getObjId();
		return data;
	},

	// show or hide "load next" node depending on collection state
	showLoaderNode: function ()
	{
		if (!this.is_visible)
			return;
		this.$('#is_next_loading').hide();
		if (this.collection.all_loaded)
		{
			this.$('.js-show-more-btn').addClass('d-none');
		} else
		{
			if (this.collection.is_next_loading)
			{
				this.$('.js-show-more-btn').addClass('d-none');
				this.$('#is_next_loading').show();
			}
			else
			{
				this.$('.js-show-more-btn').removeClass('d-none');
				$(window).scroll(); // to check if "load next" trigger is in view
			}
		}
	},

	load: function (force_load)
	{
		var folder_id = this.docs_list_state.get('folder_id');
		var changing_folder = this.collection.folder_id != folder_id;

		if (changing_folder || force_load || this.isReloadNeeded())
		{
			this.collection.keywords = this.filter_model.get('keywords');

			if (changing_folder)
					search_form.reset();

			this.collection.load(folder_id, 0, this.pagesize);
		} else
		{
			this.collection.trigger('reset');
		}
	},

	// load next portion of data into collection
	loadNext: function ()
	{
		if (!this.is_visible || this.collection == null || this.collection.all_loaded)
			return;
		if (this.isReloadNeeded())
			this.load();
		else if (!this.collection.is_next_loading)
		{
			this.collection.loadNextPortion(this.pagesize);
			this.showLoaderNode();
		}
	},

	setModel: function (docs_list_state)
	{
		this.docs_list_state = docs_list_state;
		this.docs_list_state.bind('change', function () {if (this.is_visible) {this.load();aside_view.render();}}, this);

		this.setCollection(new DocsCollection());
	},

	// returns true if loaded collection needs to be reloaded due to filter change
	isReloadNeeded: function ()
	{
		if (this.collection.all_loaded && this.collection.keywords == '')
			return false;
		if (this.collection.keywords == this.filter_model.get('keywords'))
			return false;
		if (this.collection.all_loaded && this.filter_model.get('keywords').toLowerCase().indexOf(this.collection.keywords.toLowerCase()) >= 0)
			return false;

		return true;
	},

	onFilterChange: function ()
	{
		if (this.isReloadNeeded())
			this.load();
		else
			this.render();
	}
});

