/**
 * View for the trash can list
 */
var TrashCanView = DocsListViewBase.extend({
    el: $('#mainTrashcan'),
    statusMessage: lmsg('documents.trash_can_view.documents_trash_can'),
    document_template: _.template($('#trashcan_item_template').html()),

    initialize: function ()
    {
        DocsListViewBase.prototype.initialize.call(this);
        this.setCollection(new TrashCanCollection());
        this.selected_collection = new TrashCanSelectedCollection();
        this.selected_actions_view = new TrashCanActionsView();
        this.info_menu_view = new TrashCanMenuActionsView();
        $('#trashcan_tip_display').show();
    },

    setViewMode: function (view_mode)
    {
        if(view_mode === "thumb") {
            this.document_template = _.template($('#trashcan_item_template_thumb').html());
        } else {
            this.document_template = _.template($('#trashcan_item_template').html());
        }
        this.render();
    },


    setVisible: function (visible)
    {
        DocsListViewBase.prototype.setVisible.call(this, visible);
        if (visible)
        {
            if (!this.collection.is_loaded)
            {
                this.collection.load();
                this.renderLoading();
            }
            else
                this.render();
        }
    },

    onCheckbox: function (cb_value, checked)
    {
        var obj = this.collection.get(cb_value);

        if (checked)
            this.selected_docs.add(obj);
        else
            this.selected_docs.remove(obj);
    },

    onShowMenu: function (event)
    {
        var menu = $('.dropdown-menu', event.target);

        var trash_id = $('input[name=selected_doc]', event.target).val();
        var object = this.collection.get(trash_id);

        if (object)
        {
            this.doShowMenu(object, menu);
        }
    },

    toTemplateData: function (trash_item)
    {
        var data = trash_item.toJSON();

        data.type = 'document'; // this is just for parent class so it uses the right template
        //console.log(data);
        return data;
    }

});

