(function($){
	var ic = ic || {};
	ic.iconView = 'cards--grid';
	ic.listView = 'cards--list';

	ic.clickToggle = function() {
		ic.toggleView( $(this).data('type') );
		return false;
	}

	ic.toggleView = function(className) {
		var projectList = $('#projectList')
			alt = className === ic.iconView ? ic.listView : ic.iconView;

		localStorage.setItem("view", className);

		projectList.addClass(className).removeClass(alt);

		$('[data-type="' + className +'"]').addClass('active').siblings().removeClass('active');
	}

	ic.search = function() {
		var term = $('#searchIC').val(),
			items = $('.ic-project');

		items.each(function(){
			var check = $(this).find('.ic-project-title:Contains("' + term + '")').length >= 1
				className = check ? 'search-active' : 'd-none',
				alt = !check ? 'search-active' : 'd-none'
			$(this).addClass(className).removeClass(alt);
		});

		// reset highlighted results if no filter term is empty
		if(term.length === 0) {
			items.removeClass('search-active').removeClass('d-none');
		}
	}

	$(document).ready(function() {
		var className = ic.iconView;
		if(localStorage.getItem("view") === ic.iconView || localStorage.getItem("view") === ic.listView) {
			className = localStorage.getItem("view")
		}
		ic.toggleView( className );

		$('.js-list-toggle').on('click', ic.clickToggle)
		$('#searchIC').on('keyup', ic.search).focus();
	});
})(jQuery);
