define([], function()
{
	function MailSettings(imapVal)
	{
		this.$mail_service_reply = $('#mail_service_reply_checkbox');
		this.checkReplyVisibility(this.$mail_service_reply);
		this.checkSectionVisibility(0);

		this.popup = $('#mail_settings_form');

		var self = this;
		this.$mail_service_reply.on('change', function(){self.checkReplyVisibility($(this))});
		$('#use_mailgun').on('change', function(){self.checkSectionVisibility()});
		$('#use_mail_fetching').on('change', function(){self.checkMailFetchToggle($(this))});
		$('#mail_service_fetch_protocol').on('change', function(){self.changePort($(this))});
		$('#mail_service_pass1').on('keyup', function(){self.changePassword()});
		$('#mail_service_pass2').on('keyup', function(){self.changePassword()});
		$('.js-test-connection').on('click', function(event){self.testConnection(event)})

		this.imapVal=imapVal;
		this.pop3_port = this.popup.find('input[name=port]').val();
		this.imap_port = 143;
		this.option_val = this.popup.find('select[name=fetch_protocol]').val();
		if (this.option_val == this.imapVal)
		{
			this.imap_port = this.pop3_port;
			this.pop3_port = 110;
		}

		this.default_check_interval = 3600;

		this.checkMailFetchToggle($('#use_mail_fetching'));
	}

	MailSettings.prototype.checkReplyVisibility = function($reply)
	{
		var disabled = !$reply.prop('checked');

		$('#mail_service_reply_subject').prop('disabled', disabled);
		$('#mail_service_reply_text').prop('disabled', disabled);
	};

	MailSettings.prototype.checkSectionVisibility = function(animSpeed)
	{
		// Animate if called by callback
		if (typeof animSpeed === 'undefined')
			animSpeed = 300;

		var isSelected = $('#use_mailgun').prop('checked');
		if (isSelected)
			$('#collapseMailgun').show(animSpeed);
		else
			$('#collapseMailgun').hide(animSpeed);

		isSelected = $('#use_mail_fetching').prop('checked');
		if (isSelected)
			$('#collapseMailFetching').show(animSpeed);
		else
			$('#collapseMailFetching').hide(animSpeed);
	};

	MailSettings.prototype.changePort = function($protocol)
	{
		var option = $protocol.val();
		if (option == this.imapVal)
		{
			this.pop3_port = this.popup.find('input[name=mail_service_port]').val();
			this.popup.find('input[name=mail_service_port]').val(this.imap_port);
		}
		else
		{
			this.imap_port = this.popup.find('input[name=mail_service_port]').val();
			this.popup.find('input[name=mail_service_port]').val(this.pop3_port);
		}
	};

	MailSettings.prototype.checkMailFetchToggle = function(mailFetchToggle)
	{
		if (mailFetchToggle.prop('checked'))
		{
			this.popup.find('select[name=mail_service_recheck_period]').val(this.default_check_interval);
			$('.js-test-connection').show();
		}
		else
		{
			this.popup.find('select[name=mail_service_recheck_period]').val(0);
			$('.js-test-connection').hide();
		}

		this.checkSectionVisibility();
	};

	MailSettings.prototype.changePassword = function()
	{
		var pass1 = $('#mail_service_pass1').val();
		var pass2 = $('#mail_service_pass2').val();

		if (pass1 !== pass2)
			$('#password_warning').show();
		else
			$('#password_warning').hide();
	};

	MailSettings.prototype.testConnection = function(event)
	{
		event.preventDefault();

		var formData = this.popup.serializeArray();
		var data = formData.reduce(function(obj, item) {
			obj[item.name] = item.value;
			return obj;
		}, {});

		var $button = $(event.target);
		$button.find('.js-loading').show();
		$button.find('.js-icon').hide();
		$button.attr('disabled', true);

		$.ajax({
			url: '/api/infocapture/v1/projects/' + data.project_id + '/test-mail-connection',
			type: 'POST',
			contentType: 'application/json',
			dataType: 'json',
			data: JSON.stringify(data),
			success: function(response) {
				cla.showMessage(response.message, '', !response.success);
			},
			error: function() {
				cla.showMessage(lmsg('helpdesk.admin.mail_fetch.unknown_error'), '', true);
			},
			complete: function() {
				$button.find('.js-loading').hide();
				$button.find('.js-icon').show();
				$button.attr('disabled', false);
			}
		});
	};

	return MailSettings;
});