//parse as a bare string until encountering a brace
%token  STRING              [^{]+
// {# signals the start of an expression, switch into expression lexing mode
%token  BEGIN               {#                  -> stmt
// we don't currently allow sub-statements, but accepting this as a token leads to better error messages
%token  stmt:BEGIN          {#                  -> stmt
// } closes an expression
%token  stmt:END            }                   -> default
// { on its own is the beginning of an identifier, switch into identifier lexing mode
%token  BRACE_              {                   -> ident

// we skip whitespace while in expression parsing mode
%skip   stmt:space          \s

//field names can start with numbers! wtf! pls deprecate
%token  stmt:NAME           [0-9]+[A-z_][A-z0-9\-_]*|[A-z_][A-z0-9-_]*

// identifiers take the form {namespace:name} or just {name}
%token  stmt:BRACE_         {                   -> ident
%token  ident:NAME          [^\s:{}]+
%token  ident:SEPARATOR     :
%token  ident:_BRACE        }                   -> __shift__

//literal values
%token  stmt:NUMBER         [0-9]+(\.[0-9]+)?

// Strings allow escaped quotes when possible but the combination \\" must be treated as a backslash-terminated end of the string to avoid overruns (BT-2489)
%token  stmt:QUOTE_         "                   -> string
%token  string:STRING       (?:[^\\]\\"|[^"])+
%token  string:_QUOTE       "                   -> stmt

// Strings allow escaped quotes when possible but the combination \\' must be treated as a backslash-terminated end of the string to avoid overruns  (BT-2489)
%token  stmt:SQUOTE_        '                   -> pstring
%token  pstring:STRING      (?:[^\\]\\'|[^'])+
%token  pstring:_SQUOTE     '                   -> stmt

// we can make these case-insensitive by adding (?i) to the beginning
%token  stmt:TRUE           true
%token  stmt:FALSE          false

// separator for argument lists
%token  stmt:COMMA          ,

// brackets
%token  stmt:BRACKET_       \(
%token  stmt:_BRACKET       \)

// Operators
%token  stmt:PLUS           \+
%token  stmt:MINUS          -
%token  stmt:TIMES          \*
%token  stmt:DIVIDE         /
%token  stmt:VALUEOF        \$
%token  stmt:LABELOF        @
