<?php
$_db_migration_to = '26.03';
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_restore_like_count.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

// re-add "like_count" column to let Ideaspace and Knowledgebase be upgraded from pre-Cla8 version
$col = $db->GetColumnDescription('discussions', 'like_count');
if (empty($col))
{
	$db->AddColumn('discussions', 'like_count', 'INT DEFAULT 0');
}

DB_UPDATE_FILE
);


$migrations->Run('02_admin_panels.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations Claromentis\Setup\SetupFacade */
$migrations->GetAdminPanelCreator()->Delete('courses');

DB_UPDATE_FILE
);


$migrations->Run('03_move_plugins_file.php', <<<'DB_UPDATE_FILE'
<?php
// move plugins.json from "local_data" to "data" folder
/** @var $migrations Claromentis\Setup\SetupFacade */

$data_dir = realpath($migrations->GetDataDir());
$local_data_dir = realpath($migrations->GetLocalDataDir());

if ($data_dir !== $local_data_dir && file_exists($local_data_dir.'/config/plugins.json'))
{
	if (!is_dir($data_dir.'/config'))
	{
		mkdir($data_dir . '/config');
	}
	rename($local_data_dir.'/config/plugins.json', $data_dir.'/config/plugins.json');
}

DB_UPDATE_FILE
);


$migrations->Run('04_migrate_news_comments.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$db->query("INSERT INTO discussions (user_id, object_id, ancillary, aggregation, parent_id, attachment_id, txt, timestamp, like_count, reply_count)
	SELECT user_id, object_id, status, aggregation, 0, 0, comment_text, date_created, 0, 0 FROM comments WHERE aggregation=21"); // 21 is AGGREGATION_NEWS

$db->query("DELETE FROM comments WHERE aggregation=21"); // 21 is AGGREGATION

DB_UPDATE_FILE
);


$migrations->Run('05_add_suspended_col.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$db->AddColumn('rb_obj', 'is_suspended', 'BOOL NOT_NULL DEFAULT 0');

$db->query("DELETE FROM rb_events WHERE room_id NOT IN (SELECT id FROM rb_obj)"); // remove bookings of non-existent objects
$db->query("DELETE FROM rb_confirm WHERE obj_id NOT IN (SELECT id FROM rb_obj) OR book_id NOT IN (SELECT id FROM rb_events)"); // remove confirmation requests for non-existent objects and bookings
$db->query("DELETE FROM rb_links WHERE obj_id NOT IN (SELECT id FROM rb_obj) AND obj_id NOT IN(SELECT id FROM rb_events)"); // remove links that refer to non-existent bookings and objects

DB_UPDATE_FILE
);


$migrations->Run('06_drop_old_chat_tables.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->DropTable('discuss_chat');
$db->DropTable('discuss_instruct');
$db->DropTable('discuss_message');
$db->DropTable('discuss_session');
$db->DropTable('discuss_sessionchat');
$db->DropTable('discuss_userchat');

DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('26.03');
