<?php
$_db_migration_to = '26.04';
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_blog_comments_migration.php', <<<'DB_UPDATE_FILE'
<?php

/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();


// Copy old comments to the new system
$result = $db->query('SELECT * FROM comments WHERE aggregation = int:aggregation', 120);   // 120 == AGGREGATION_BLOG
$db->DisableTokenCheck();
while ($arr = $result->fetchArray())
{
	$data =
	[
		'int:user_id' => (int)$arr['user_id'],
		'int:object_id' => (int)$arr['object_id'],
		'int:aggregation' => (int)$arr['aggregation'],
		'str:txt' => $arr['comment_text'],
		'int:timestamp' => (int)$arr['date_created'],
		'int:ancillary' => null,
		'int:attachment_id' => null,
		'int:reply_count' => null,
	];
	$dbi = new \Claromentis\Core\DAL\QueryInsert('discussions', $data);
	$db->query($dbi);
}

$result = $db->query('DELETE FROM comments WHERE aggregation = int:aggregation', 120);   // 120 == AGGREGATION_BLOG

// Remove 'moderated comments' status (a bitmask of 2) from all blog posts.
// Hard-coded rather than messing about trying to do bit masking and manipulation in SQL.
// There were 3 options (1, 2 and 4 bitmasks) so possible values are 0-7. The ones which would include a bitmask of 2 are 2, 3, 6 and 7
$db->query('UPDATE blog_post SET comments_mode = (comments_mode - 2) WHERE comments_mode IN (2,3,6,7)');

$db->EnableTokenCheck();
DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('26.04');
