<?php
$_db_migration_to = '27.06'; // 8.1.2
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('02_utf8mb4indexes2.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$indent = '    ';
echo($indent . "Modifying metadata tables - this will take some time, please be patient\n");
echo($indent . "  ERMS_metadata_element\n");
$db->DropIndex('ERMS_metadata_element', 'ERMS_metadata_element_names');
$db->AlterColumn('ERMS_metadata_element', 'name', 'name', 'VARCHAR(100)');
$db->CreateIndex('ERMS_metadata_element', 'ERMS_metadata_element_names', 'name');

echo($indent . "  ERMS_metadata_field\n");
$db->DropIndex('ERMS_metadata_field', 'ERMS_metadata_field_name');
$db->AlterColumn('ERMS_metadata_field', 'name', 'name', 'VARCHAR(100)');
$db->CreateIndex('ERMS_metadata_field', 'ERMS_metadata_field_name', 'name');

echo($indent . "  ERMS_metadata_inherit\n");
$db->DropPrimaryKey('ERMS_metadata_inherit');
$db->AlterColumn('ERMS_metadata_inherit', 'name', 'name', "VARCHAR(100) NOT_NULL DEFAULT ' '");
$db->CreatePrimaryKey('ERMS_metadata_inherit', 'object_id', 'aggregation', 'name', 'parent_id');

echo($indent . "  ERMS_metadata_link\n");
$db->AlterColumn('ERMS_metadata_link', 'name', 'name', 'VARCHAR(100)');

echo($indent . "  metadata_simple\n");
$db->DropIndex('metadata_simple', 'metadata_simple_index_1');
$db->AlterColumn('metadata_simple', 'name', 'name', 'VARCHAR(100)');
$db->CreateIndex('metadata_simple', 'metadata_simple_index_1', 'aggregation', 'object_id', 'name');


// Just recreate all oauth tables


// oauth_access_token_scopes
$table_descr = array(
	'id'	=>	"IDENTITY",
	'access_token'	=>	"VARCHAR(150) NULL",
	'scope'	=>	"VARCHAR(150) NULL",
);

$db->CreateTable('oauth_access_token_scopes', $table_descr, true);
$db->CreateIndex('oauth_access_token_scopes', 'oauth_access_token_scopes_access_token_foreign', 'access_token');
$db->CreateIndex('oauth_access_token_scopes', 'oauth_access_token_scopes_scope_foreign', 'scope');



// oauth_access_tokens
$table_descr = array(
	'access_token'	=>	"VARCHAR(150) NOT_NULL DEFAULT ' '",
	'session_id'	=>	"INT NOT_NULL",
	'expire_time'	=>	"INT NOT_NULL",
);

$db->CreateTable('oauth_access_tokens', $table_descr, true);
$db->CreatePrimaryKey('oauth_access_tokens', 'access_token');
$db->CreateIndex('oauth_access_tokens', 'oauth_access_tokens_session_id_foreign', 'session_id');



// oauth_auth_code_scopes
$table_descr = array(
	'id'	=>	"IDENTITY",
	'auth_code'	=>	"VARCHAR(150) NULL",
	'scope'	=>	"VARCHAR(150) NULL",
);

$db->CreateTable('oauth_auth_code_scopes', $table_descr, true);
$db->CreateIndex('oauth_auth_code_scopes', 'oauth_auth_code_scopes_auth_code_foreign', 'auth_code');
$db->CreateIndex('oauth_auth_code_scopes', 'oauth_auth_code_scopes_scope_foreign', 'scope');



// oauth_auth_codes
$table_descr = array(
	'auth_code'	=>	"VARCHAR(150) NOT_NULL DEFAULT ' '",
	'session_id'	=>	"INT NOT_NULL",
	'expire_time'	=>	"INT NOT_NULL",
	'client_redirect_uri'	=>	"VARCHAR(150) NULL",
);

$db->CreateTable('oauth_auth_codes', $table_descr, true);
$db->CreatePrimaryKey('oauth_auth_codes', 'auth_code');
$db->CreateIndex('oauth_auth_codes', 'oauth_auth_codes_session_id_foreign', 'session_id');



// oauth_client_redirect_uris
$table_descr = array(
	'client_id'	=>	"VARCHAR(150) NULL",
	'redirect_uri'	=>	"VARCHAR(150) NULL",
);

$db->CreateTable('oauth_client_redirect_uris', $table_descr, true);



// oauth_clients
$table_descr = array(
	'id'	=>	"VARCHAR(150) NOT_NULL DEFAULT ' '",
	'secret'	=>	"VARCHAR(150) NULL",
	'name'	=>	"VARCHAR(150) NULL",
);

$db->CreateTable('oauth_clients', $table_descr, true);
$db->CreatePrimaryKey('oauth_clients', 'id');



// oauth_refresh_tokens
$table_descr = array(
	'refresh_token'	=>	"VARCHAR(150) NOT_NULL DEFAULT ' '",
	'expire_time'	=>	"INT NOT_NULL",
	'access_token'	=>	"VARCHAR(150) NULL",
);

$db->CreateTable('oauth_refresh_tokens', $table_descr, true);
$db->CreatePrimaryKey('oauth_refresh_tokens', 'refresh_token');
$db->CreateIndex('oauth_refresh_tokens', 'oauth_refresh_tokens_access_token_foreign', 'access_token');



// oauth_scopes
$table_descr = array(
	'id'	=>	"VARCHAR(150) NOT_NULL DEFAULT ' '",
	'description'	=>	"VARCHAR(150) NULL",
);

$db->CreateTable('oauth_scopes', $table_descr, true);
$db->CreatePrimaryKey('oauth_scopes', 'id');



// oauth_session_scopes
$table_descr = array(
	'id'	=>	"IDENTITY",
	'session_id'	=>	"INT NOT_NULL",
	'scope'	=>	"VARCHAR(150) NULL",
);

$db->CreateTable('oauth_session_scopes', $table_descr, true);
$db->CreateIndex('oauth_session_scopes', 'oauth_session_scopes_session_id_foreign', 'session_id');
$db->CreateIndex('oauth_session_scopes', 'oauth_session_scopes_scope_foreign', 'scope');



// oauth_sessions
$table_descr = array(
	'id'	=>	"IDENTITY",
	'owner_type'	=>	"VARCHAR(150) NULL",
	'owner_id'	=>	"VARCHAR(150) NULL",
	'client_id'	=>	"VARCHAR(150) NULL",
	'client_redirect_uri'	=>	"VARCHAR(150) NULL",
);

$db->CreateTable('oauth_sessions', $table_descr, true);
$db->CreateIndex('oauth_sessions', 'oauth_sessions_client_id_foreign', 'client_id');



echo($indent . "Modifying variables table\n");
$db->DropPrimaryKey('variables');
$db->AlterColumn('variables', 'var_name', 'var_name', "VARCHAR(100) NOT_NULL DEFAULT ' '");
$db->CreatePrimaryKey('variables', 'var_name');

DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('27.06');
