<?php
$_db_migration_to = '28.03'; // 8.2.0-beta2
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_menu_personal_link_length.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->AlterColumn('infobar_menu_personal', 'link', 'link', 'VARCHAR(1024) NULL');

DB_UPDATE_FILE
);


$migrations->Run('01_telemetry_background_minute.php', <<<'DB_UPDATE_FILE'
<?php

// set the telemetry payload to be generated and sent at a random minute in
// the hour between 3 and 4am on Mondays
$minute = mt_rand(1, 59);
DBVar::Set('telemetry_bg_minute', $minute);

DB_UPDATE_FILE
);


$migrations->Run('02_empty_search_update.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

// drop table that might have been created during the work-in-progress
@$db->DropTable('empty_searches');

// Empty Searches
$table_descr = array(
	'id' =>	"IDENTITY",
	'user_id' => "INT NOT_NULL",
	'date_created' => "INT_DATE NOT_NULL",
	'keywords' => "VARCHAR(255)"
);

$db->CreateTable('empty_search', $table_descr, true);

DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('28.03');
